/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlayerTitleUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AcceptInvitationCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "acceptInvitation";
    }

    @Override
    public String permission() {
        return "playerGuild.acceptInvitation";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer invitationGuildId = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Optional<GuildPlayer> optionalGuildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (optionalGuildPlayer.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("haveGuild"));
            return;
        }
        List<Integer> guildIdList = GuildConstants.INVITATION_PLAYER_MAP.get(player.getName());
        if (CollUtil.isEmpty(guildIdList) || !guildIdList.contains(invitationGuildId)) {
            MessageUtil.sendMessage(player, ConfigUtil.INVITATION_CONFIG.getString("member.noInvitation"));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(invitationGuildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildInfo.getMemberCount() + 1 > guildInfo.getMemberMaxCount()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("numberFailureMsg"));
            return;
        }
        GuildApplyService.getInstance().updateApplyResultByPlayerName(player.getName(), ApplyTypeEnum.CANCEL.getId());
        GuildPlayer guildPlayer = new GuildPlayer();
        guildPlayer.setGuildInfoId(guildInfo.getId());
        guildPlayer.setGuildInfoName(guildInfo.getGuildName());
        guildPlayer.setPlayerName(player.getName());
        guildPlayer.setPlayerUuid(player.getUniqueId().toString());
        guildPlayer.setPvpStatus(guildInfo.getPvpStatus());
        guildPlayer.setRoleId(GuildRoleEnum.FOUR.getRoleId());
        GuildPlayerService.getInstance().add(guildPlayer);
        GuildConstants.PLAYER_GUILD_MAP.put(player.getUniqueId(), guildPlayer);
        GuildInfoService.getInstance().addMemberCount(guildInfo.getId(), 1);
        PlayerTitleUtil.addGuildPlayerTitle(guildPlayer.getPlayerName(), guildInfo.getTitleId());
        GuildConstants.INVITATION_PLAYER_MAP.remove(player.getName());
        MessageUtil.sendMessage(player, ConfigUtil.INVITATION_CONFIG.getString("member.acceptMsg"));
        MessageUtil.sendMessage(args[2], ConfigUtil.INVITATION_CONFIG.getString("member.acceptJoinMsg", "").replace("${player}", player.getName()));
    }
}

