/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.WorldUtil;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateWorldCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "createWorld";
    }

    @Override
    public String permission() {
        return "playerGuild.createWorld";
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        boolean enable = ConfigUtil.SETTING_CONFIG.getBoolean("createGuildWorld.enable");
        if (!enable) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("createWorldMsg"));
        this.createWorld(player);
    }

    public synchronized void createWorld(Player player) {
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (!GuildRoleEnum.ONE.getRoleId().equals(guildPlayer.getRoleId())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noPermission"));
            return;
        }
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId());
        if (!guildInfoOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (StrUtil.isNotEmpty(guildInfo.getWorldName())) {
            MessageUtil.sendMessage(player, ConfigUtil.WORLD_CONFIG.getString("HasBeenCreated"));
            return;
        }
        String format = ConfigUtil.SETTING_CONFIG.getString("createGuildWorld.format", "world_guild/");
        String dateFormat = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String worldName = format + player.getName().toLowerCase() + "_" + dateFormat;
        String aliasName = ConfigUtil.WORLD_CONFIG.getString("aliasName", "${guildName}").replace("${guildName}", guildPlayer.getGuildInfoName());
        WorldUtil.createWorld(player, guildPlayer.getGuildInfoId(), worldName, aliasName);
    }
}

