/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DenyPvpCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "denyPvp";
    }

    @Override
    public String permission() {
        return "playerGuild.denyPvp";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        this.match(player);
        this.season(player);
    }

    private void match(Player player) {
        Map<Integer, List<UUID>> pvpPlayerMap = MatchConstants.GUILD_PVP_PREPARATION_MAP;
        if (pvpPlayerMap.isEmpty()) {
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpNotPrepareMsg"));
            return;
        }
        GuildPlayer guild = guildPlayerOptional.get();
        List<UUID> uuidList = pvpPlayerMap.get(guild.getGuildInfoId());
        if (uuidList == null) {
            MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpNotPrepareMsg"));
            return;
        }
        uuidList.remove(player.getUniqueId());
        pvpPlayerMap.put(guild.getGuildInfoId(), uuidList);
        MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpDenyPrepareMsg"));
    }

    private void season(Player player) {
        Map<Integer, List<UUID>> pvpPlayerMap = SeasonConstants.GUILD_PVP_PREPARATION_MAP;
        if (pvpPlayerMap.isEmpty()) {
            return;
        }
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpNotPrepareMsg"));
            return;
        }
        GuildPlayer guild = guildPlayerOptional.get();
        List<UUID> uuidList = pvpPlayerMap.get(guild.getGuildInfoId());
        if (uuidList == null) {
            MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpNotPrepareMsg"));
            return;
        }
        uuidList.remove(player.getUniqueId());
        pvpPlayerMap.put(guild.getGuildInfoId(), uuidList);
        MessageUtil.sendMessage(player, ConfigUtil.ACTIVITY_CONFIG.getString("matePvpDenyPrepareMsg"));
    }
}

