/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.command.function;

import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.command.IHandyCommandEvent;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.GuildUtil;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaveCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "leave";
    }

    @Override
    public String permission() {
        return "playerGuild.leave";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] strings) {
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!guildPlayerOptional.isPresent()) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        if (GuildRoleEnum.ONE.getRoleId().equals(guildPlayer.getRoleId())) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("oneLeaveMsg"));
            return;
        }
        GuildUtil.callPlayerLeaveGuildEvent(player, guildPlayer.getId());
    }
}

