/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.constants;

import com.handy.guild.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;

public enum GuildSortEnum {
    PROSPERITY_DEGREE(1, "prosperity_degree", "guildSort.prosperityDegree"),
    LEVEL(2, "level", "guildSort.level"),
    MONEY(3, "money", "guildSort.money"),
    CREATE_TIME(4, "create_time", "guildSort.createTime"),
    MEMBER_COUNT(5, "member_count", "guildSort.memberCount"),
    MONTH_PROSPERITY_DEGREE(6, "month_prosperity_degree", "guildSort.monthProsperityDegree");

    private final Integer id;
    private final String name;
    private final String desc;

    public static List<String> getSortList() {
        ArrayList<String> list = new ArrayList<String>();
        for (GuildSortEnum guildSortEnum : GuildSortEnum.values()) {
            list.add(guildSortEnum.getName());
        }
        return list;
    }

    public static GuildSortEnum getEnum(String name) {
        for (GuildSortEnum guildSortEnum : GuildSortEnum.values()) {
            if (!guildSortEnum.getName().equalsIgnoreCase(name)) continue;
            return guildSortEnum;
        }
        return PROSPERITY_DEGREE;
    }

    public static GuildSortEnum getNextEnum(String name) {
        GuildSortEnum anEnum = GuildSortEnum.getEnum(name);
        if (anEnum == null) {
            return PROSPERITY_DEGREE;
        }
        int num = anEnum.getId() + 1;
        if (num > 6) {
            num = 1;
        }
        for (GuildSortEnum guildSortEnum : GuildSortEnum.values()) {
            if (guildSortEnum.getId() != num) continue;
            return guildSortEnum;
        }
        return PROSPERITY_DEGREE;
    }

    public static String getTypeName(GuildSortEnum guildSortEnum) {
        return BaseUtil.getLangMsg(guildSortEnum.desc);
    }

    private GuildSortEnum(Integer id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

