/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.constants;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildPvpLog;
import com.handy.guild.enter.GuildPvpPlayerLog;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.service.GuildPvpLogService;
import com.handy.guild.service.GuildPvpPlayerLogService;
import com.handy.guild.service.GuildPvpService;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.OfflinePlayer;

public enum PapiHandleEnum {
    NAME("name", "%playerGuild_name%"),
    SHOW_NAME("show_name", "%playerGuild_show_name%"),
    MONEY("money", "%playerGuild_money%"),
    ROLE("role", "%playerGuild_role%"),
    GUILD_COUNT("guild_count", "%playerGuild_guild_count%"),
    KILL("kill", "%playerGuild_kill%"),
    DIE("die", "%playerGuild_die%"),
    GUILD_SEASON_RANK("guild_season_rank", "%playerGuild_guild_season_rank%"),
    GUILD_LOGO("guild_logo", "%guild_logo%"),
    GUILD_LEVEL("guild_level", "%guild_level%"),
    GUILD_MEMBER_COUNT("guild_member_count", "%guild_member_count%"),
    GUILD_MEMBER_MAX_COUNT("guild_member_max_count", "%playerGuild_guild_member_max_count%"),
    GUILD_MONEY("guild_money", "%guild_money%"),
    GUILD_PROSPERITY_DEGREE("guild_prosperity_degree", "%playerGuild_guild_prosperity_degree%"),
    GUILD_MONTH_PROSPERITY_DEGREE("guild_month_prosperity_degree", "%playerGuild_guild_month_prosperity_degree%");

    private final String placeholder;
    private final String desc;

    private static PapiHandleEnum getEnum(String placeholder) {
        for (PapiHandleEnum papiHandleEnum : PapiHandleEnum.values()) {
            if (!papiHandleEnum.getPlaceholder().equalsIgnoreCase(placeholder)) continue;
            return papiHandleEnum;
        }
        return null;
    }

    public static String execution(OfflinePlayer player, String placeholder) {
        String str = "";
        PapiHandleEnum papiHandleEnum = PapiHandleEnum.getEnum(placeholder);
        if (papiHandleEnum == null) {
            return str;
        }
        switch (papiHandleEnum) {
            case NAME: {
                GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
                if (guildPlayer == null) {
                    guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                }
                str = guildPlayer != null ? guildPlayer.getGuildInfoName() : ConfigUtil.CONFIG.getString("default");
                break;
            }
            case SHOW_NAME: {
                String prefixBrackets = ConfigUtil.CONFIG.getString("prefixBrackets");
                String suffixBrackets = ConfigUtil.CONFIG.getString("suffixBrackets");
                GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
                if (guildPlayer == null) {
                    guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                }
                str = guildPlayer != null ? prefixBrackets + guildPlayer.getGuildInfoName() + suffixBrackets : ConfigUtil.CONFIG.getString("default");
                break;
            }
            case MONEY: {
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                str = guildPlayer != null ? guildPlayer.getMoney().toString() : "0";
                break;
            }
            case ROLE: {
                GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
                if (guildPlayer == null) {
                    guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                }
                str = guildPlayer != null ? GuildRoleEnum.getRoleName(guildPlayer.getRoleId()) : BaseUtil.getLangMsg("role.not", "");
                break;
            }
            case GUILD_COUNT: {
                Integer count = GuildInfoService.getInstance().findCount();
                str = count.toString();
                break;
            }
            case KILL: {
                int kill = 0;
                List<GuildPvpPlayerLog> killGuildPvpPlayerLogs = GuildPvpPlayerLogService.getInstance().findByPlayerName(player.getName());
                if (CollUtil.isNotEmpty(killGuildPvpPlayerLogs)) {
                    kill = killGuildPvpPlayerLogs.stream().map(GuildPvpPlayerLog::getKill).mapToInt(Integer::intValue).sum();
                }
                str = Integer.toString(kill);
                break;
            }
            case DIE: {
                int die = 0;
                List<GuildPvpPlayerLog> dieGuildPvpPlayerLogs = GuildPvpPlayerLogService.getInstance().findByPlayerName(player.getName());
                if (CollUtil.isNotEmpty(dieGuildPvpPlayerLogs)) {
                    die = dieGuildPvpPlayerLogs.stream().map(GuildPvpPlayerLog::getDie).mapToInt(Integer::intValue).sum();
                }
                str = Integer.toString(die);
                break;
            }
            case GUILD_SEASON_RANK: {
                Optional<GuildPvpLog> guildPvpLogOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null) break;
                Integer season = GuildPvpService.getInstance().findSeason();
                if (season > 1) {
                    season = season - 1;
                }
                if (!(guildPvpLogOptional = GuildPvpLogService.getInstance().findRankBySeason(guildPlayer.getGuildInfoId(), season)).isPresent()) break;
                str = guildPvpLogOptional.get().getRank().toString();
                break;
            }
            case GUILD_LOGO: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = ItemStackUtil.itemStackDeserialize(guildInfo.getLogoName()).getType().name();
                break;
            }
            case GUILD_LEVEL: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getLevel().toString();
                break;
            }
            case GUILD_MEMBER_COUNT: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getMemberCount().toString();
                break;
            }
            case GUILD_MEMBER_MAX_COUNT: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getMemberMaxCount().toString();
                break;
            }
            case GUILD_MONEY: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getMoney().toString();
                break;
            }
            case GUILD_PROSPERITY_DEGREE: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getProsperityDegree().toString();
                break;
            }
            case GUILD_MONTH_PROSPERITY_DEGREE: {
                Optional<GuildInfo> guildInfoOptional;
                GuildPlayer guildPlayer = GuildPlayerService.getInstance().findByPlayerName(player.getName()).orElse(null);
                if (guildPlayer == null || !(guildInfoOptional = GuildInfoService.getInstance().findById(guildPlayer.getGuildInfoId())).isPresent()) break;
                GuildInfo guildInfo = guildInfoOptional.get();
                str = guildInfo.getMonthProsperityDegree().toString();
                break;
            }
        }
        return BaseUtil.replaceChatColor(str);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getDesc() {
        return this.desc;
    }

    private PapiHandleEnum(String placeholder, String desc) {
        this.placeholder = placeholder;
        this.desc = desc;
    }
}

