/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.hook;

import cn.handyplus.chat.api.PlayerChatApi;
import com.handy.guild.PlayerGuild;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerChatUtil {
    private PlayerChatUtil() {
    }

    public static void regChannel() {
        if (!PlayerGuild.USE_CHAT) {
            return;
        }
        List<GuildInfo> guildInfoList = GuildInfoService.getInstance().findAll();
        if (CollUtil.isEmpty(guildInfoList)) {
            return;
        }
        List ids = guildInfoList.stream().map(s -> String.valueOf(s.getId())).collect(Collectors.toList());
        PlayerChatApi.getInstance().regChannel((Plugin)PlayerGuild.INSTANCE, ids);
    }

    public static void regChannel(Integer guildId) {
        if (!PlayerGuild.USE_CHAT) {
            return;
        }
        PlayerChatApi.getInstance().regChannel((Plugin)PlayerGuild.INSTANCE, guildId.toString());
    }

    public static void unRegChannel() {
        if (!PlayerGuild.USE_CHAT) {
            return;
        }
        PlayerChatApi.getInstance().unRegChannel((Plugin)PlayerGuild.INSTANCE);
    }

    public static void unRegChannel(Integer guildId) {
        if (!PlayerGuild.USE_CHAT) {
            return;
        }
        PlayerChatApi.getInstance().unRegChannel((Plugin)PlayerGuild.INSTANCE, guildId.toString());
    }

    public static void regPlayerChannel(Player player, Integer guildInfoId) {
        if (!PlayerGuild.USE_CHAT || player == null) {
            return;
        }
        PlayerChatApi.getInstance().regPlayerChannel((Plugin)PlayerGuild.INSTANCE, guildInfoId.toString(), player);
    }

    public static void unRegPlayerChannel(Player player, Integer guildInfoId) {
        if (!PlayerGuild.USE_CHAT || player == null) {
            return;
        }
        PlayerChatApi.getInstance().unRegPlayerChannel((Plugin)PlayerGuild.INSTANCE, guildInfoId.toString(), player);
    }

    public static void setPlayerChannel(Player player) {
        if (!PlayerGuild.USE_CHAT) {
            return;
        }
        GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
        if (guildPlayer == null) {
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("noGuildMsg"));
            return;
        }
        PlayerChatApi.getInstance().setPlayerChannel((Plugin)PlayerGuild.INSTANCE, guildPlayer.getGuildInfoId().toString(), player);
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("joinChannel"));
    }

    public static void setPlayerChannelToDefault(Player player) {
        if (!PlayerGuild.USE_CHAT || player == null) {
            return;
        }
        PlayerChatApi.getInstance().setPlayerChannelToDefault(player);
    }
}

