/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.hook;

import com.handy.guild.PlayerGuild;
import com.handy.guild.enter.GuildTask;
import com.handy.guild.enter.GuildTaskDemand;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.DateUtil;
import com.handy.guild.service.GuildTaskDemandService;
import com.handy.guild.service.GuildTaskService;
import com.handy.guild.util.ConfigUtil;
import com.handy.playertask.api.PlayerTaskApi;
import com.handy.playertask.entity.TaskDemand;
import com.handy.playertask.entity.TaskList;
import java.util.List;

public class PlayerTaskUtil {
    private PlayerTaskUtil() {
    }

    public static void createTask(Integer guildId) {
        if (!PlayerGuild.USE_TASK || !ConfigUtil.TASK_CONFIG.getBoolean("enable", true)) {
            return;
        }
        List taskIdList = ConfigUtil.TASK_CONFIG.getIntegerList("taskId");
        if (CollUtil.isEmpty(taskIdList)) {
            return;
        }
        for (Integer taskId : taskIdList) {
            TaskList taskList;
            if (taskId == 0 || (taskList = PlayerTaskApi.getInstance().findDetailByTaskId(taskId)) == null || CollUtil.isEmpty(taskList.getTaskDemands())) continue;
            GuildTask guildTask = new GuildTask();
            guildTask.setGuildInfoId(guildId);
            guildTask.setTaskId(taskId);
            guildTask.setTaskName(taskList.getTaskName());
            guildTask.setStatus(false);
            guildTask.setDemandSuccess(false);
            guildTask.setStartDate(DateUtil.getMonday());
            guildTask.setEndDate(DateUtil.getSunday());
            int guildTaskId = GuildTaskService.getInstance().add(guildTask);
            for (TaskDemand taskDemand : taskList.getTaskDemands()) {
                GuildTaskDemand guildTaskDemand = new GuildTaskDemand();
                guildTaskDemand.setGuildInfoId(guildId);
                guildTaskDemand.setTaskId(taskId);
                guildTaskDemand.setGuildTaskId(guildTaskId);
                guildTaskDemand.setType(taskDemand.getType());
                guildTaskDemand.setCompletionAmount(0);
                guildTaskDemand.setAmount(taskDemand.getAmount());
                guildTaskDemand.setItemStack(taskDemand.getItemStack());
                guildTaskDemand.setStartDate(DateUtil.getMonday());
                guildTaskDemand.setEndDate(DateUtil.getSunday());
                GuildTaskDemandService.getInstance().add(guildTaskDemand);
            }
        }
    }
}

