/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildCreateGui {
    private static final GuildCreateGui INSTANCE = new GuildCreateGui();

    private GuildCreateGui() {
    }

    public static GuildCreateGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, String guildName) {
        String title = ConfigUtil.CREATE_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.CREATE_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_CREATE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(guildName);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    private void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_CREATE.getType());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        String guildName = handyInventory.getSearchType();
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_CONFIG, inventory, "point", this.replaceMap(player, "point", guildName));
        HandyInventoryUtil.setButton(ConfigUtil.CREATE_CONFIG, inventory, "vault", this.replaceMap(player, "vault", guildName));
    }

    private Map<String, String> replaceMap(Player player, String type, String guildName) {
        int money;
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        String yes = ConfigUtil.CREATE_CONFIG.getString("yesButton");
        String button = ConfigUtil.CREATE_CONFIG.getString("noButton");
        int price = ConfigUtil.CREATE_CONFIG.getInt(type + ".price");
        if ("point".equals(type)) {
            int playerPoints;
            money = playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else {
            double playerVault = VaultUtil.getPlayerVault(player);
            money = (int)playerVault;
            if (playerVault >= (double)price) {
                button = yes;
            }
        }
        map.put("price", price + "");
        map.put("guild_name", guildName);
        map.put("money", Integer.toString(money));
        map.put("button", button);
        return map;
    }
}

