/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildLogo;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildLogoService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuildLogoOpenGui {
    private static final GuildLogoOpenGui INSTANCE = new GuildLogoOpenGui();

    private GuildLogoOpenGui() {
    }

    public static GuildLogoOpenGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.LOGO_SHOP_CONFIG.getString("openTitle");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.LOGO_SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_LOGO_OPEN.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_LOGO_OPEN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Integer guildId = handyInventory.getId();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        Page<GuildLogo> page = GuildLogoService.getInstance().page(guildId, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        String selUseButton = ConfigUtil.LOGO_SHOP_CONFIG.getString("selUseButton");
        String useButton = ConfigUtil.LOGO_SHOP_CONFIG.getString("useButton");
        List<GuildLogo> records = page.getRecords();
        for (GuildLogo record : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(record.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            ArrayList<String> loreList = itemMeta.getLore();
            if (CollUtil.isEmpty(loreList)) {
                loreList = new ArrayList<String>();
            }
            if (record.getUseFlag() != null && record.getUseFlag().booleanValue()) {
                loreList.add(useButton);
                ItemStackUtil.setEnchant(itemMeta);
                ItemStackUtil.hideEnchant(itemMeta);
            } else {
                loreList.add(selUseButton);
            }
            ItemStackUtil.hideAttributes(itemMeta);
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "pane");
    }
}

