/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildManageMemberGui {
    private static final GuildManageMemberGui INSTANCE = new GuildManageMemberGui();

    private GuildManageMemberGui() {
    }

    public static GuildManageMemberGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id, Integer guildPlayerId) {
        String title = ConfigUtil.MANAGE_MEMBER_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.MANAGE_MEMBER_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_MANAGE_MEMBER_CREATE.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        handyInventory.setObj(guildPlayerId);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_MANAGE_MEMBER_CREATE.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        boolean up;
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Integer guildPlayerId = Integer.valueOf(handyInventory.getObj().toString());
        Optional<GuildPlayer> guildPlayerOptional = GuildPlayerService.getInstance().findById(guildPlayerId);
        if (!guildPlayerOptional.isPresent()) {
            return;
        }
        GuildPlayer guildPlayer = guildPlayerOptional.get();
        Optional<GuildPlayer> clickGuildPlayerOpt = GuildPlayerService.getInstance().findByPlayerName(player.getName());
        if (!clickGuildPlayerOpt.isPresent()) {
            return;
        }
        GuildPlayer clickGuildPlayer = clickGuildPlayerOpt.get();
        boolean bl = up = !clickGuildPlayer.getRoleId().equals(GuildRoleEnum.TWO.getRoleId()) || !guildPlayer.getRoleId().equals(GuildRoleEnum.THREE.getRoleId());
        if (up) {
            HandyInventoryUtil.setButton(ConfigUtil.MANAGE_MEMBER_CONFIG, inventory, "up", this.replaceMap(guildPlayer));
        }
        HandyInventoryUtil.setButton(ConfigUtil.MANAGE_MEMBER_CONFIG, inventory, "down", this.replaceMap(guildPlayer));
        HandyInventoryUtil.setButton(ConfigUtil.MANAGE_MEMBER_CONFIG, inventory, "ban");
        HandyInventoryUtil.setButton(ConfigUtil.MANAGE_MEMBER_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(GuildPlayer guildPlayer) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(3);
        map.put("role", GuildRoleEnum.getRoleName(guildPlayer.getRoleId()));
        map.put("upRole", GuildRoleEnum.getRoleName(guildPlayer.getRoleId() - 1));
        map.put("downRole", GuildRoleEnum.getRoleName(guildPlayer.getRoleId() + 1));
        return map;
    }
}

