/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildPlayerSignIn;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.HandyPermissionUtil;
import com.handy.guild.service.GuildPlayerSignInService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GuildSignInGui {
    private static final GuildSignInGui INSTANCE = new GuildSignInGui();

    private GuildSignInGui() {
    }

    public static GuildSignInGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer id) {
        String title = ConfigUtil.SIGN_IN_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SIGN_IN_CONFIG.getInt("size", 27);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.GUILD_SIGN_IN.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setId(id);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.GUILD_SIGN_IN.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setFunctionMenu(handyInventory);
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Optional<GuildPlayerSignIn> guildPlayerSignInOptional = GuildPlayerSignInService.getInstance().findByPlayerName(player.getName());
        HandyInventoryUtil.setButton(ConfigUtil.SIGN_IN_CONFIG, inventory, "point", this.replaceMap(player, "point", guildPlayerSignInOptional.orElse(null)));
        HandyInventoryUtil.setButton(ConfigUtil.SIGN_IN_CONFIG, inventory, "vault", this.replaceMap(player, "vault", guildPlayerSignInOptional.orElse(null)));
        HandyInventoryUtil.setButton(ConfigUtil.SIGN_IN_CONFIG, inventory, "back");
    }

    private Map<String, String> replaceMap(Player player, String type, GuildPlayerSignIn guildPlayerSignIn) {
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(3);
        String yes = ConfigUtil.SIGN_IN_CONFIG.getString("yesButton");
        String no = ConfigUtil.SIGN_IN_CONFIG.getString("noButton");
        String signedIn = ConfigUtil.SIGN_IN_CONFIG.getString("signedInButton");
        String button = no;
        int price = ConfigUtil.SIGN_IN_CONFIG.getInt(type + ".price");
        if ("point".equals(type)) {
            int playerPoints = PlayerPointsUtil.getPlayerPoints(player);
            if (playerPoints >= price) {
                button = yes;
            }
        } else {
            double playerVault = VaultUtil.getPlayerVault(player);
            if (playerVault >= (double)price) {
                button = yes;
            }
        }
        if (guildPlayerSignIn != null) {
            button = signedIn;
        }
        int money = ConfigUtil.SIGN_IN_CONFIG.getInt(type + ".money");
        Double vip = HandyPermissionUtil.getDoubleNumber(player, ConfigUtil.SIGN_IN_CONFIG, "signIn");
        int permissionMoney = (int)((double)money * vip);
        String moneyStr = String.valueOf(money);
        if (money != permissionMoney) {
            moneyStr = " \u00a7m" + money + "\u00a7a " + permissionMoney;
        }
        replaceMap.put("money", moneyStr);
        replaceMap.put("price", String.valueOf(price));
        replaceMap.put("button", button);
        return replaceMap;
    }
}

