/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildLogoShop;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildLogoShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewLogoShopGui {
    private static final ViewLogoShopGui INSTANCE = new ViewLogoShopGui();

    private ViewLogoShopGui() {
    }

    public static ViewLogoShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.LOGO_SHOP_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.LOGO_SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_LOGO_SHOP.getType(), title, size);
        handyInventory.setPageNum(1);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_LOGO_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildLogoShop> page = GuildLogoShopService.getInstance().page(null, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildLogoShop> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        List loreList = ConfigUtil.LOGO_SHOP_CONFIG.getStringList("logo.view");
        for (GuildLogoShop record : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(record.getItemStack());
            List<String> newLoreList = ItemStackUtil.loreReplaceMap(loreList, this.replaceMap(record));
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setLore(BaseUtil.replaceChatColor(newLoreList));
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.LOGO_SHOP_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(GuildLogoShop guildLogoShop) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(4);
        map.put("id", guildLogoShop.getId().toString());
        map.put("price", guildLogoShop.getPrice().toString());
        map.put("level", guildLogoShop.getLevel().toString());
        map.put("button", ConfigUtil.LOGO_SHOP_CONFIG.getString("delButton"));
        return map;
    }
}

