/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.ShopBuyLimitTypeEnum;
import com.handy.guild.enter.GuildShop;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildShopService;
import com.handy.guild.util.ConfigUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewShopGui {
    private static final ViewShopGui INSTANCE = new ViewShopGui();

    private ViewShopGui() {
    }

    public static ViewShopGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.SHOP_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.SHOP_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_SHOP.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_SHOP.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildShop> page = GuildShopService.getInstance().page(handyInventory.getPageNum(), handyInventory.getPageSize(), Collections.singletonList(0));
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildShop> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        for (GuildShop record : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(record.getItemStack());
            List loreList = ConfigUtil.SHOP_CONFIG.getStringList("logo.view");
            List lore = ItemStackUtil.getItemMeta(itemStack).getLore();
            if (CollUtil.isNotEmpty(lore)) {
                lore.addAll(loreList);
                loreList = lore;
            }
            List<String> newLoreList = ItemStackUtil.loreReplaceMap(loreList, this.replaceMap(record));
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setLore(BaseUtil.replaceChatColor(newLoreList));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            map.put(index, record.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.SHOP_CONFIG, inventory, "pane");
    }

    private Map<String, String> replaceMap(GuildShop guildShop) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(5);
        Integer number = guildShop.getNumber();
        String unlimited = ConfigUtil.SHOP_CONFIG.getString("unlimited", "&a\u65e0\u9650\u5236");
        map.put("number", number == 0 ? unlimited : number.toString());
        map.put("price", guildShop.getPrice().toString());
        map.put("level", guildShop.getLevel().toString());
        map.put("button", ConfigUtil.SHOP_CONFIG.getString("delButton"));
        ShopBuyLimitTypeEnum shopBuyLimitTypeEnum = ShopBuyLimitTypeEnum.getEnumDefaultOnly(guildShop.getType());
        map.put("buyType", ShopBuyLimitTypeEnum.getTypeName(shopBuyLimitTypeEnum));
        return map;
    }
}

