/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.inventory;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildSpawnPvpLocation;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.service.GuildSpawnPvpLocationService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewSpawnLocationGui {
    private static final ViewSpawnLocationGui INSTANCE = new ViewSpawnLocationGui();

    private ViewSpawnLocationGui() {
    }

    public static ViewSpawnLocationGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, Integer pvpLocationId) {
        String title = ConfigUtil.PVP_LOCATION_CONFIG.getString("title");
        title = PlaceholderApiUtil.set(player, title);
        int size = ConfigUtil.PVP_LOCATION_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW_SPAWN_LOCATION.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setSearchType(pvpLocationId.toString());
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW_SPAWN_LOCATION.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Integer pvpLocationId = Integer.valueOf(handyInventory.getSearchType());
        Map<Integer, Integer> intMap = handyInventory.getIntMap();
        handyInventory.setPageSize(GuildConstants.GUI_INDEX.size());
        Page<GuildSpawnPvpLocation> page = GuildSpawnPvpLocationService.getInstance().page(pvpLocationId, handyInventory.getPageNum(), handyInventory.getPageSize());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        List<GuildSpawnPvpLocation> records = page.getRecords();
        int i = 0;
        List<Integer> guiIndexList = GuildConstants.GUI_INDEX;
        String delButton = ConfigUtil.PVP_LOCATION_CONFIG.getString("delButton");
        for (GuildSpawnPvpLocation guildSpawnPvpLocation : records) {
            Integer index = guiIndexList.get(i++);
            ItemStack itemStack = new ItemStack(ItemStackUtil.getMaterial(Material.ARROW.name()));
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(guildSpawnPvpLocation.getSpawnName()));
            ArrayList<String> loreList = itemMeta.getLore();
            if (CollUtil.isEmpty(loreList)) {
                loreList = new ArrayList<String>();
            }
            loreList.add(delButton);
            itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
            itemStack.setItemMeta(itemMeta);
            inventory.setItem(index.intValue(), itemStack);
            intMap.put(index, guildSpawnPvpLocation.getId());
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.PVP_LOCATION_CONFIG, inventory, "pane");
    }
}

