/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.lib.expand.adapter;

import com.handy.guild.lib.expand.adapter.BukkitScheduler;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerSchedulerUtil {
    private PlayerSchedulerUtil() {
    }

    public static boolean teleport(Entity entity, Location target) {
        return PlayerSchedulerUtil.teleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean teleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            return (Boolean)entity.teleportAsync(target, cause).join();
        }
        return entity.teleport(target, cause);
    }

    public static void syncTeleport(Entity entity, Location target) {
        PlayerSchedulerUtil.syncTeleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static void syncTeleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            entity.teleportAsync(target, cause).join();
        }
        BukkitScheduler.runTask(() -> entity.teleport(target, cause));
    }

    public static void performCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.chat(player, command), () -> {});
            return;
        }
        PlayerSchedulerUtil.chat(player, command);
    }

    public static void syncPerformCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.chat(player, command), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> PlayerSchedulerUtil.chat(player, command));
    }

    public static void performOpCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.opChat(player, command), () -> {});
            return;
        }
        PlayerSchedulerUtil.opChat(player, command);
    }

    public static void syncPerformOpCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.opChat(player, command), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> PlayerSchedulerUtil.opChat(player, command));
    }

    public static void addPotionEffects(Player player, List<PotionEffect> potionEffectList) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> player.addPotionEffects((Collection)potionEffectList), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> player.addPotionEffects((Collection)potionEffectList));
    }

    public static void removePotionEffect(Player player, PotionEffectType potionEffect) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> player.removePotionEffect(potionEffect), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> player.removePotionEffect(potionEffect));
    }

    private static void chat(Player player, String command) {
        player.chat("/" + command.trim());
    }

    private static void opChat(Player player, String command) {
        boolean op = player.isOp();
        try {
            if (!op) {
                player.setOp(true);
            }
            PlayerSchedulerUtil.chat(player, command);
        }
        finally {
            player.setOp(op);
        }
    }
}

