/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.gui;

import com.handy.guild.constants.GuiTypeEnum;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.hook.PlayerPointsUtil;
import com.handy.guild.hook.VaultUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.inventory.HandyInventoryUtil;
import com.handy.guild.lib.inventory.IHandyClickEvent;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.util.ConfigUtil;
import com.handy.guild.util.GuildUtil;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class GuildCreateClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.GUILD_CREATE.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        String guildName = handyInventory.getSearchType().trim();
        HandySchedulerUtil.runTask(() -> ((Player)player).closeInventory());
        Optional<GuildInfo> infoOptional = GuildInfoService.getInstance().findByGuildName(guildName);
        if (infoOptional.isPresent()) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("duplicateName"));
            return;
        }
        boolean rst = false;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_CONFIG, "point")) {
            int pointPrice = ConfigUtil.CREATE_CONFIG.getInt("point.price");
            rst = PlayerPointsUtil.buy(player, pointPrice);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_CONFIG, "vault")) {
            int vaultPrice = ConfigUtil.CREATE_CONFIG.getInt("vault.price");
            rst = VaultUtil.buy(player, vaultPrice);
        }
        if (!rst) {
            MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("notMoneyFailureMsg"));
            return;
        }
        GuildUtil.callGuildCreateEvent(player, guildName);
    }
}

