/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.listener.pvp;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.util.ConfigUtil;
import java.util.List;
import org.bukkit.entity.Player;

public class PvpCheckUtil {
    public static boolean check(Player damagePlayer, Player entityPlayer) {
        if (!ConfigUtil.SETTING_CONFIG.getBoolean("pvp.enable", false)) {
            return false;
        }
        List noWorldList = ConfigUtil.SETTING_CONFIG.getStringList("pvp.noWorld");
        if (CollUtil.isNotEmpty(noWorldList) && noWorldList.contains(damagePlayer.getWorld().getName())) {
            return false;
        }
        if (GuildConstants.PLAYER_API_PVP_MAP.get(damagePlayer.getUniqueId()) != null || GuildConstants.PLAYER_API_PVP_MAP.get(entityPlayer.getUniqueId()) != null) {
            return false;
        }
        boolean matchCheck = PvpCheckUtil.matchCheck(damagePlayer, entityPlayer);
        if (matchCheck) {
            return true;
        }
        boolean seasonCheck = PvpCheckUtil.seasonCheck(damagePlayer, entityPlayer);
        if (seasonCheck) {
            return true;
        }
        return PvpCheckUtil.guildCheck(damagePlayer, entityPlayer);
    }

    private static boolean guildCheck(Player damagePlayer, Player entityPlayer) {
        GuildPlayer damageGuildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(damagePlayer.getUniqueId());
        GuildPlayer entityGuildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(entityPlayer.getUniqueId());
        return damageGuildPlayer != null && entityGuildPlayer != null && damageGuildPlayer.getGuildInfoId().equals(entityGuildPlayer.getGuildInfoId()) && damageGuildPlayer.getPvpStatus() != false && entityGuildPlayer.getPvpStatus() != false;
    }

    private static boolean matchCheck(Player damagePlayer, Player entityPlayer) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        return MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(entityPlayer.getUniqueId()) != null && MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(damagePlayer.getUniqueId()) == null;
    }

    private static boolean seasonCheck(Player damagePlayer, Player entityPlayer) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return false;
        }
        return SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(entityPlayer.getUniqueId()) != null && SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(damagePlayer.getUniqueId()) == null;
    }
}

