/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildChannel;
import com.handy.guild.lib.db.Db;
import java.util.Optional;

public class GuildChannelService {
    private GuildChannelService() {
    }

    public static GuildChannelService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildChannel enter) {
        enter.setId(this.findMaxId());
        Db.use(GuildChannel.class).execution().insert(enter);
    }

    public void delById(Integer id) {
        Db.use(GuildChannel.class).execution().deleteById(id);
    }

    public Optional<GuildChannel> findByPlayerNameAndServerName(String playerName, String serverName) {
        Db<GuildChannel> db = Db.use(GuildChannel.class);
        db.where().eq(GuildChannel::getPlayerName, playerName).eq(GuildChannel::getServerName, serverName);
        return db.execution().selectOne();
    }

    public Integer findMaxId() {
        Db<GuildChannel> db = Db.use(GuildChannel.class);
        db.where().orderByDesc(GuildChannel::getId).limit(1, 1);
        Optional<GuildChannel> warpChannelOpt = db.execution().selectOne();
        return warpChannelOpt.map(guildChannel -> guildChannel.getId() + 1).orElse(1);
    }

    private static class SingletonHolder {
        private static final GuildChannelService INSTANCE = new GuildChannelService();

        private SingletonHolder() {
        }
    }
}

