/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildNotice;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.db.Db;
import com.handy.guild.lib.db.enter.Page;
import com.handy.guild.service.GuildNoticeReadService;
import java.util.List;
import java.util.Optional;

public class GuildNoticeService {
    private GuildNoticeService() {
    }

    public static GuildNoticeService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public int add(GuildNotice guildNotice) {
        return Db.use(GuildNotice.class).execution().insert(guildNotice);
    }

    public Optional<GuildNotice> findById(Integer id) {
        return Db.use(GuildNotice.class).execution().selectById(id);
    }

    public void delById(Integer id) {
        Db.use(GuildNotice.class).execution().deleteById(id);
        GuildNoticeReadService.getInstance().delByGuildNoticeId(id);
    }

    public List<GuildNotice> list(Integer guildInfoId, List<Integer> readIds) {
        Db<GuildNotice> db = Db.use(GuildNotice.class);
        db.where().eq(GuildNotice::getGuildInfoId, guildInfoId).notIn(CollUtil.isNotEmpty(readIds), GuildNotice::getId, readIds).orderByDesc(GuildNotice::getCreateTime);
        return db.execution().list();
    }

    public Page<GuildNotice> page(Integer guildInfoId, Integer pageNum, Integer pageSize, List<Integer> readIds, String type) {
        Db<GuildNotice> db = Db.use(GuildNotice.class);
        db.where().eq(GuildNotice::getGuildInfoId, guildInfoId).notIn(CollUtil.isNotEmpty(readIds) && "noRead".equals(type), GuildNotice::getId, readIds).limit(pageNum, pageSize).orderByDesc(GuildNotice::getCreateTime);
        return db.execution().page();
    }

    public Page<GuildNotice> page(Integer pageNum, Integer pageSize) {
        Db<GuildNotice> db = Db.use(GuildNotice.class);
        db.where().limit(pageNum, pageSize).orderByDesc(GuildNotice::getCreateTime);
        return db.execution().page();
    }

    public void delByGuildId(Integer guildId) {
        Db<GuildNotice> use = Db.use(GuildNotice.class);
        use.where().eq(GuildNotice::getGuildInfoId, guildId);
        use.execution().delete();
    }

    public List<GuildNotice> findAll() {
        return Db.use(GuildNotice.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildNoticeService INSTANCE = new GuildNoticeService();

        private SingletonHolder() {
        }
    }
}

