/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.service;

import com.handy.guild.enter.GuildShopLog;
import com.handy.guild.lib.db.Db;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class GuildShopLogService {
    private GuildShopLogService() {
    }

    public static GuildShopLogService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void add(GuildShopLog guildShopLog) {
        Db.use(GuildShopLog.class).execution().insert(guildShopLog);
    }

    public void addNumber(Integer id, Integer number) {
        Db<GuildShopLog> use = Db.use(GuildShopLog.class);
        use.update().add(GuildShopLog::getNumber, GuildShopLog::getNumber, number).set(GuildShopLog::getBuyTime, new Date());
        use.execution().updateById(id);
    }

    public Optional<GuildShopLog> findByPlayerName(String playerName, String type, Integer guildShopId) {
        Db<GuildShopLog> use = Db.use(GuildShopLog.class);
        use.where().eq(GuildShopLog::getType, type).eq(GuildShopLog::getGuildShopId, guildShopId).eq(GuildShopLog::getPlayerName, playerName);
        return use.execution().selectOne();
    }

    public Integer findCountByPlayerName(String playerName, String type, Integer guildShopId, Date startTime, Date endTime) {
        Db<GuildShopLog> use = Db.use(GuildShopLog.class);
        use.where().eq(GuildShopLog::getType, type).eq(GuildShopLog::getGuildShopId, guildShopId).eq(GuildShopLog::getPlayerName, playerName).ge(GuildShopLog::getBuyTime, startTime).le(GuildShopLog::getBuyTime, endTime);
        return use.execution().count();
    }

    public void delByGuildShopId(Integer guildShopId) {
        Db<GuildShopLog> use = Db.use(GuildShopLog.class);
        use.where().eq(GuildShopLog::getGuildShopId, guildShopId);
        use.execution().delete();
    }

    public List<GuildShopLog> findAll() {
        return Db.use(GuildShopLog.class).execution().list();
    }

    private static class SingletonHolder {
        private static final GuildShopLogService INSTANCE = new GuildShopLogService();

        private SingletonHolder() {
        }
    }
}

