/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.handy.guild.constants.GuildConstants;
import com.handy.guild.enter.GuildBuff;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.event.GuildBuffEvent;
import com.handy.guild.hook.PlaceholderApiUtil;
import com.handy.guild.lib.attribute.AttributeEnum;
import com.handy.guild.lib.attribute.AttributeUtil;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.FormulaUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.service.GuildBuffService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BuffManageUtil {
    private BuffManageUtil() {
    }

    private static void addBuff(Player player, List<String> buffList) {
        if (CollUtil.isEmpty(buffList)) {
            return;
        }
        String buffType = ConfigUtil.SACRED_STONE_CONFIG.getString("buffType");
        AttributeEnum attributeEnum = AttributeEnum.getEnum(buffType);
        if (attributeEnum == null) {
            return;
        }
        AttributeUtil.getInstance().addAttribute(player, buffList, attributeEnum);
    }

    public static void removeBuff(Player player) {
        if (player == null) {
            return;
        }
        String buffType = ConfigUtil.SACRED_STONE_CONFIG.getString("buffType");
        AttributeEnum attributeEnum = AttributeEnum.getEnum(buffType);
        if (attributeEnum == null) {
            return;
        }
        AttributeUtil.getInstance().removeAttribute(player, attributeEnum);
    }

    public static void setBuff(Player player, List<String> buffList) {
        BuffManageUtil.removeBuff(player);
        BuffManageUtil.addBuff(player, buffList);
    }

    public static synchronized void refreshCallBuffEvent(Integer guildId) {
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByGuildId(guildId);
        for (GuildPlayer guildPlayer : guildPlayerList) {
            Optional<Player> onlinePlayerOpt = BaseUtil.getOnlinePlayer(UUID.fromString(guildPlayer.getPlayerUuid()));
            onlinePlayerOpt.ifPresent(BuffManageUtil::callBuffEvent);
        }
    }

    public static void callBuffEvent(Player player) {
        if (player == null) {
            return;
        }
        GuildPlayer guildPlayer = GuildConstants.PLAYER_GUILD_MAP.get(player.getUniqueId());
        if (guildPlayer == null) {
            return;
        }
        Map<String, GuildBuff> guildBuffMap = GuildBuffService.getInstance().findByGuildId(guildPlayer.getGuildInfoId());
        if (guildBuffMap.isEmpty()) {
            return;
        }
        ArrayList<String> attributeList = new ArrayList<String>();
        for (String type : guildBuffMap.keySet()) {
            List list = ConfigUtil.SACRED_STONE_CONFIG.getStringList("buff." + type + ".attribute");
            if (CollUtil.isEmpty(list)) continue;
            HashMap<String, String> map = MapUtil.of("level", guildBuffMap.get(type).getLevel().toString());
            for (String attribute : list) {
                String formulaBuff = FormulaUtil.evaluateFormula(PlaceholderApiUtil.set(player, attribute), map);
                attributeList.add(formulaBuff);
            }
        }
        HandySchedulerUtil.runTaskLater(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildBuffEvent(player, attributeList)), 20L);
    }
}

