/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.google.common.collect.Maps;
import com.handy.guild.command.function.AcceptCommand;
import com.handy.guild.constants.ApplyTypeEnum;
import com.handy.guild.constants.GuildRoleEnum;
import com.handy.guild.constants.MatchConstants;
import com.handy.guild.constants.SeasonConstants;
import com.handy.guild.enter.GuildApply;
import com.handy.guild.enter.GuildInfo;
import com.handy.guild.enter.GuildPlayer;
import com.handy.guild.enter.GuildSpawnPvpLocation;
import com.handy.guild.event.GuildClearMonthProsperityDegreeEvent;
import com.handy.guild.event.GuildCreateEvent;
import com.handy.guild.event.GuildPvpDeathEvent;
import com.handy.guild.event.GuildPvpEndEvent;
import com.handy.guild.event.GuildPvpMatchEvent;
import com.handy.guild.event.GuildPvpPreparationEvent;
import com.handy.guild.event.GuildPvpStartEvent;
import com.handy.guild.event.GuildSeasonPvpDeathEvent;
import com.handy.guild.event.GuildSeasonPvpEndEvent;
import com.handy.guild.event.GuildSeasonPvpPreparationEvent;
import com.handy.guild.event.GuildSeasonPvpStartEvent;
import com.handy.guild.event.PlayerJoinGuildEvent;
import com.handy.guild.event.PlayerLeaveGuildEvent;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.MapUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.inventory.HandyInventory;
import com.handy.guild.lib.util.AssertUtil;
import com.handy.guild.lib.util.BaseUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.GuildPvpPlayerParam;
import com.handy.guild.param.GuildSeasonPvpPlayerParam;
import com.handy.guild.param.GuildSpawn;
import com.handy.guild.service.GuildApplyService;
import com.handy.guild.service.GuildInfoService;
import com.handy.guild.service.GuildPlayerService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GuildUtil {
    private GuildUtil() {
    }

    public static Location getLocation(GuildSpawn spawn) {
        return new Location(Bukkit.getWorld((String)spawn.getWorld()), spawn.getX(), spawn.getY(), spawn.getZ(), spawn.getYaw(), spawn.getPitch());
    }

    public static Location getLocation(GuildSpawnPvpLocation pvpLocation) {
        return new Location(Bukkit.getWorld((String)pvpLocation.getWorld()), pvpLocation.getX(), pvpLocation.getY(), pvpLocation.getZ(), (float)pvpLocation.getYaw(), (float)pvpLocation.getPitch());
    }

    public static Map<Integer, Color> getColorMap() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put(0, Color.RED);
        map.put(1, Color.BLUE);
        map.put(2, Color.GRAY);
        map.put(3, Color.BLACK);
        map.put(4, Color.WHITE);
        map.put(5, Color.MAROON);
        map.put(6, Color.YELLOW);
        map.put(7, Color.OLIVE);
        map.put(8, Color.LIME);
        map.put(9, Color.GREEN);
        map.put(10, Color.AQUA);
        map.put(11, Color.TEAL);
        map.put(12, Color.SILVER);
        map.put(13, Color.NAVY);
        map.put(14, Color.FUCHSIA);
        map.put(15, Color.PURPLE);
        map.put(16, Color.ORANGE);
        return map;
    }

    public static void joinGuild(Integer guildIndoId, Player player) {
        Optional<GuildInfo> guildInfoOptional = GuildInfoService.getInstance().findById(guildIndoId);
        if (!guildInfoOptional.isPresent()) {
            return;
        }
        GuildInfo guildInfo = guildInfoOptional.get();
        if (guildInfo.getMemberCount() + 1 > guildInfo.getMemberMaxCount()) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("numberFailureMsg"));
            return;
        }
        if (guildInfo.getJoinMode() != null && !guildInfo.getJoinMode().booleanValue()) {
            AcceptCommand.getGuildPlayer(null, player.getName(), player.getUniqueId().toString(), guildInfo);
            return;
        }
        GuildApply guildApply = new GuildApply();
        guildApply.setGuildInfoId(guildInfo.getId());
        guildApply.setPlayerName(player.getName());
        guildApply.setPlayerUuid(player.getUniqueId().toString());
        guildApply.setApplyTime(new Date());
        guildApply.setApplyResult(ApplyTypeEnum.PENDING.getId());
        int guildApplyId = GuildApplyService.getInstance().add(guildApply);
        AssertUtil.notTrue(guildApplyId < 1, (CommandSender)player, BaseUtil.getLangMsg("failureMsg"));
        String guildName = BaseUtil.replaceChatColor(guildInfo.getGuildName());
        MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("joinApplyMsg").replace("${guild_name}", guildName));
        List<GuildPlayer> guildPlayerList = GuildPlayerService.getInstance().findByIdAndRoleIds(guildInfo.getId(), Arrays.asList(GuildRoleEnum.ONE.getRoleId(), GuildRoleEnum.TWO.getRoleId()));
        for (GuildPlayer guildPlayer : guildPlayerList) {
            Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(guildPlayer.getPlayerName());
            if (!onlinePlayer.isPresent()) continue;
            GuildUtil.sendApplyMessage(player.getName(), guildApplyId, onlinePlayer.get());
        }
    }

    public static void sendApplyMessage(String applyPlayerName, int guildApplyId, Player sendPlayer) {
        String responseMsg = BaseUtil.getMsgNotColor("joinApplyNoticeMsg");
        responseMsg = StrUtil.replace(responseMsg, "player", applyPlayerName);
        responseMsg = StrUtil.replace(responseMsg, "id", String.valueOf(guildApplyId));
        TextComponent message = new TextComponent(BaseUtil.getLangMsg("accept"));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg accept " + guildApplyId));
        TextComponent messageDown = new TextComponent(BaseUtil.getLangMsg("refuse"));
        messageDown.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg deny " + guildApplyId));
        message.addExtra((BaseComponent)messageDown);
        MessageUtil.sendMessage(sendPlayer, responseMsg);
        MessageUtil.sendMessage(sendPlayer, message);
    }

    public static void sendInvitationMessage(String invitationPlayerName, GuildInfo guildInfo, String sendPlayerName) {
        String invitationMsg = ConfigUtil.INVITATION_CONFIG.getString("member.invitationMsg", "");
        invitationMsg = StrUtil.replace(invitationMsg, "player", invitationPlayerName);
        invitationMsg = StrUtil.replace(invitationMsg, "guildName", guildInfo.getGuildName());
        TextComponent message = new TextComponent(BaseUtil.replaceChatColor(ConfigUtil.INVITATION_CONFIG.getString("member.accept")));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg acceptInvitation " + guildInfo.getId() + " " + invitationPlayerName));
        TextComponent messageDown = new TextComponent(BaseUtil.replaceChatColor(ConfigUtil.INVITATION_CONFIG.getString("member.refuse")));
        messageDown.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/plg denyInvitation " + guildInfo.getId() + " " + invitationPlayerName));
        message.addExtra((BaseComponent)messageDown);
        Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(sendPlayerName);
        if (onlinePlayer.isPresent()) {
            Player sendPlayer = onlinePlayer.get();
            MessageUtil.sendMessage(sendPlayer, invitationMsg);
            MessageUtil.sendMessage(sendPlayer, message);
        }
    }

    public static void setHead(Inventory inventory) {
        if (!ConfigUtil.CONFIG.getBoolean("setHead", true)) {
            return;
        }
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof HandyInventory)) {
            return;
        }
        HandyInventory handyInventory = (HandyInventory)holder;
        Map<Integer, Object> objMap = handyInventory.getObjMap();
        if (objMap.isEmpty()) {
            return;
        }
        for (Integer index : objMap.keySet()) {
            ItemMeta itemMeta;
            Object playerName = objMap.get(index);
            ItemStack itemStack = inventory.getItem(index.intValue());
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR) || !((itemMeta = itemStack.getItemMeta()) instanceof SkullMeta)) continue;
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            skullMeta.setOwner(playerName.toString());
            itemStack.setItemMeta((ItemMeta)skullMeta);
            inventory.setItem(index.intValue(), itemStack);
        }
    }

    public static void guildPvpDeath(Player player) {
        if (MatchConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        Integer guildId = MatchConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return;
        }
        List<GuildPvpPlayerParam> playerParamList = MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
        if (CollUtil.isEmpty(playerParamList)) {
            return;
        }
        GuildUtil.guildPvpDeathEvent(player, guildId, playerParamList);
    }

    private static synchronized void guildPvpDeathEvent(Player player, Integer guildId, List<GuildPvpPlayerParam> playerParamList) {
        int deathNumber = 0;
        Integer rivalGuildId = null;
        for (GuildPvpPlayerParam playerParam : playerParamList) {
            if (playerParam.getPlayerUuid().equals(player.getUniqueId()) && !playerParam.getIsDeath().booleanValue()) {
                playerParam.setIsDeath(true);
                rivalGuildId = playerParam.getRivalGuildId();
                Player killer = player.getKiller();
                if (killer != null) {
                    for (GuildPvpPlayerParam param : MatchConstants.GUILD_PVP_START_PLAYER_MAP.get(playerParam.getRivalGuildId())) {
                        if (!param.getPlayerUuid().equals(killer.getUniqueId())) continue;
                        param.setKill(param.getKill() + 1);
                        break;
                    }
                }
                Bukkit.getServer().getPluginManager().callEvent((Event)new GuildPvpDeathEvent(player, killer));
            }
            if (!playerParam.getIsDeath().booleanValue()) continue;
            ++deathNumber;
        }
        if (playerParamList.size() == deathNumber) {
            Bukkit.getServer().getPluginManager().callEvent((Event)new GuildPvpEndEvent(guildId, rivalGuildId));
        }
    }

    public static void guildSeasonPvpDeath(Player player) {
        if (SeasonConstants.GUILD_PVP_START_PLAYER_MAP.isEmpty() || SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.isEmpty()) {
            return;
        }
        Integer guildId = SeasonConstants.GUILD_PVP_START_GUILD_PLAYER_MAP.get(player.getUniqueId());
        if (guildId == null) {
            return;
        }
        List<GuildSeasonPvpPlayerParam> guildSeasonPvpPlayerParams = SeasonConstants.GUILD_PVP_START_PLAYER_MAP.get(guildId);
        if (CollUtil.isEmpty(guildSeasonPvpPlayerParams)) {
            return;
        }
        GuildUtil.guildSeasonPvpDeath(player, guildId, guildSeasonPvpPlayerParams);
    }

    private static synchronized void guildSeasonPvpDeath(Player player, Integer guildId, List<GuildSeasonPvpPlayerParam> guildSeasonPvpPlayerParams) {
        int deathNumber = 0;
        Integer season = 1;
        for (GuildSeasonPvpPlayerParam guildSeasonPvpPlayerParam : guildSeasonPvpPlayerParams) {
            season = guildSeasonPvpPlayerParam.getSeason();
            if (guildSeasonPvpPlayerParam.getPlayerUuid().equals(player.getUniqueId())) {
                guildSeasonPvpPlayerParam.setIsDeath(true);
                Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpDeathEvent(player, player.getKiller()));
            }
            if (!guildSeasonPvpPlayerParam.getIsDeath().booleanValue()) continue;
            ++deathNumber;
        }
        if (guildSeasonPvpPlayerParams.size() == deathNumber) {
            int rank = SeasonConstants.GUILD_PVP_START_PLAYER_MAP.size();
            SeasonConstants.GUILD_PVP_START_PLAYER_MAP.remove(guildId);
            Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpEndEvent(guildId, rank, guildSeasonPvpPlayerParams, season));
        }
    }

    public static synchronized void callGuildPvpMatchEvent(Player player, Integer guildId, HandyInventory handyInventory) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildPvpMatchEvent(player, guildId, handyInventory)));
    }

    public static synchronized void callGuildPvpPreparationEvent(List<Integer> guildIdList) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildPvpPreparationEvent(guildIdList)));
    }

    public static synchronized void callGuildPvpStartEvent(List<Integer> guildIdList) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildPvpStartEvent(guildIdList)));
    }

    public static synchronized void callGuildSeasonPvpPreparationEvent(List<Integer> guildIdList, Integer season) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpPreparationEvent(guildIdList, season)));
    }

    public static synchronized void callGuildSeasonPvpStartEvent(List<Integer> guildIdList, Integer season) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpStartEvent(guildIdList, season)));
    }

    public static void callPlayerJoinGuildEvent(String playerName, String playerUuid, Integer guildInfoId) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerJoinGuildEvent(playerName, UUID.fromString(playerUuid), guildInfoId)));
    }

    public static void callPlayerLeaveGuildEvent(Player player, Integer guildPlayerId) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveGuildEvent(player, guildPlayerId)));
    }

    public static void callPlayerLeaveGuildEvent(OfflinePlayer offlinePlayer, Integer guildPlayerId) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveGuildEvent(offlinePlayer, guildPlayerId)));
    }

    public static void callGuildCreateEvent(Player player, String guildName) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildCreateEvent(player, guildName)));
    }

    public static void callGuildSeasonPvpDeathEvent(Player player, Player killer) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildSeasonPvpDeathEvent(player, killer)));
    }

    public static Map<String, List<String>> getDescriptionMap(String description) {
        return MapUtil.of("description", GuildUtil.getDescription(description));
    }

    public static void callGuildClearMonthProsperityDegreeEvent(Map<Integer, List<OfflinePlayer>> member, String guildName, Integer monthProsperityDegree) {
        HandySchedulerUtil.runTask(() -> Bukkit.getServer().getPluginManager().callEvent((Event)new GuildClearMonthProsperityDegreeEvent(member, guildName, monthProsperityDegree)));
    }

    public static List<String> getDescription(String description) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(description)) {
            loreList.add(BaseUtil.getLangMsg("noDescription"));
            return loreList;
        }
        loreList.addAll(StrUtil.strToStrList(description));
        return loreList;
    }
}

