/*
 * Decompiled with CFR 0.152.
 */
package com.handy.guild.util;

import com.handy.guild.constants.EquipmentSlotEnum;
import com.handy.guild.enter.GuildEquipment;
import com.handy.guild.enter.GuildPlayerItem;
import com.handy.guild.lib.constants.VersionCheckEnum;
import com.handy.guild.lib.core.CollUtil;
import com.handy.guild.lib.core.StrUtil;
import com.handy.guild.lib.expand.adapter.HandySchedulerUtil;
import com.handy.guild.lib.util.ItemStackUtil;
import com.handy.guild.lib.util.MessageUtil;
import com.handy.guild.param.PlayerItem;
import com.handy.guild.service.GuildPlayerItemService;
import com.handy.guild.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class LeatherUtil {
    private static final Map<UUID, PlayerItem> PLAYER_ITEM_MAP = new HashMap<UUID, PlayerItem>();

    private LeatherUtil() {
    }

    private static ItemStack setColor(ItemStack itemStack, Color color) {
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return new ItemStack(Material.AIR);
        }
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
        leatherArmorMeta.setColor(color);
        itemStack.setItemMeta((ItemMeta)leatherArmorMeta);
        return itemStack;
    }

    public static void setPlayerLeatherItemStack(Player player, Color color, List<GuildEquipment> equipmentList) {
        EntityEquipment equipment;
        PlayerInventory playerInventory = player.getInventory();
        PlayerItem playerItem = new PlayerItem();
        playerItem.setStorageContents(playerInventory.getStorageContents());
        playerItem.setArmorContents(playerInventory.getArmorContents());
        playerItem.setExtraContents(playerInventory.getExtraContents());
        playerItem.setItemOnCursor(player.getItemOnCursor());
        PLAYER_ITEM_MAP.put(player.getUniqueId(), playerItem);
        LeatherUtil.itemToDb(player, playerItem);
        playerInventory.clear();
        player.setItemOnCursor(new ItemStack(Material.AIR));
        boolean defaultEquipment = ConfigUtil.KIT_PVP_CONFIG.getBoolean("defaultEquipment", true);
        ItemStack helmet = LeatherUtil.setColor(new ItemStack(Material.LEATHER_HELMET), color);
        ItemStack chestPlate = defaultEquipment ? LeatherUtil.setColor(new ItemStack(Material.LEATHER_CHESTPLATE), color) : new ItemStack(Material.AIR);
        ItemStack leggings = defaultEquipment ? LeatherUtil.setColor(new ItemStack(Material.LEATHER_LEGGINGS), color) : new ItemStack(Material.AIR);
        ItemStack boots = defaultEquipment ? LeatherUtil.setColor(new ItemStack(Material.LEATHER_BOOTS), color) : new ItemStack(Material.AIR);
        ItemStack hand = new ItemStack(defaultEquipment ? Material.STONE_SWORD : Material.AIR);
        ItemStack offHand = new ItemStack(defaultEquipment ? Material.SHIELD : Material.AIR);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        if (CollUtil.isNotEmpty(equipmentList)) {
            block7: for (GuildEquipment guildEquipment : equipmentList) {
                EquipmentSlotEnum slotEnum;
                ItemStack itemStack = ItemStackUtil.itemStackDeserialize(guildEquipment.getItemStack());
                if (StrUtil.isNotEmpty(guildEquipment.getSlot()) && (slotEnum = EquipmentSlotEnum.getType(guildEquipment.getSlot())) != null) {
                    switch (slotEnum) {
                        case HAND: {
                            hand = itemStack;
                            continue block7;
                        }
                        case OFF_HAND: {
                            offHand = itemStack;
                            continue block7;
                        }
                        case CHEST: {
                            chestPlate = itemStack;
                            continue block7;
                        }
                        case LEGS: {
                            leggings = itemStack;
                            continue block7;
                        }
                        case FEET: {
                            boots = itemStack;
                            continue block7;
                        }
                    }
                }
                itemStackList.add(itemStack);
            }
        }
        if ((equipment = player.getEquipment()) != null) {
            equipment.setHelmet(helmet);
            equipment.setChestplate(chestPlate);
            equipment.setLeggings(leggings);
            equipment.setBoots(boots);
            equipment.setItemInMainHand(hand);
            equipment.setItemInOffHand(offHand);
        }
        if (defaultEquipment) {
            playerInventory.addItem(new ItemStack[]{new ItemStack(Material.APPLE, 64)});
            playerInventory.addItem(new ItemStack[]{new ItemStack(Material.ARROW, 64)});
            playerInventory.addItem(new ItemStack[]{new ItemStack(Material.STONE_AXE)});
            playerInventory.addItem(new ItemStack[]{new ItemStack(Material.BOW)});
        }
        for (ItemStack itemStack : itemStackList) {
            playerInventory.addItem(new ItemStack[]{itemStack});
        }
        player.updateInventory();
    }

    private static void itemToDb(Player player, PlayerItem playerItem) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            GuildPlayerItem guildPlayerItem;
            ArrayList<GuildPlayerItem> guildPlayerItems = new ArrayList<GuildPlayerItem>();
            if (playerItem.getStorageContents() != null) {
                for (ItemStack storageContent : playerItem.getStorageContents()) {
                    if (storageContent == null || Material.AIR.equals((Object)storageContent.getType())) continue;
                    guildPlayerItem = new GuildPlayerItem();
                    guildPlayerItem.setPlayerName(player.getName());
                    guildPlayerItem.setPlayerUuid(player.getUniqueId().toString());
                    guildPlayerItem.setItemStack(ItemStackUtil.itemStackSerialize(storageContent));
                    guildPlayerItem.setCreateTime(new Date());
                    guildPlayerItems.add(guildPlayerItem);
                }
            }
            if (playerItem.getArmorContents() != null) {
                for (ItemStack armorContent : playerItem.getArmorContents()) {
                    if (armorContent == null || Material.AIR.equals((Object)armorContent.getType())) continue;
                    guildPlayerItem = new GuildPlayerItem();
                    guildPlayerItem.setPlayerName(player.getName());
                    guildPlayerItem.setPlayerUuid(player.getUniqueId().toString());
                    guildPlayerItem.setItemStack(ItemStackUtil.itemStackSerialize(armorContent));
                    guildPlayerItem.setCreateTime(new Date());
                    guildPlayerItems.add(guildPlayerItem);
                }
            }
            if (playerItem.getExtraContents() != null) {
                for (ItemStack extraContents : playerItem.getExtraContents()) {
                    if (extraContents == null || Material.AIR.equals((Object)extraContents.getType())) continue;
                    guildPlayerItem = new GuildPlayerItem();
                    guildPlayerItem.setPlayerName(player.getName());
                    guildPlayerItem.setPlayerUuid(player.getUniqueId().toString());
                    guildPlayerItem.setItemStack(ItemStackUtil.itemStackSerialize(extraContents));
                    guildPlayerItem.setCreateTime(new Date());
                    guildPlayerItems.add(guildPlayerItem);
                }
            }
            if (playerItem.getItemOnCursor() != null && !Material.AIR.equals((Object)playerItem.getItemOnCursor().getType())) {
                GuildPlayerItem guildPlayerItem2 = new GuildPlayerItem();
                guildPlayerItem2.setPlayerName(player.getName());
                guildPlayerItem2.setPlayerUuid(player.getUniqueId().toString());
                guildPlayerItem2.setItemStack(ItemStackUtil.itemStackSerialize(playerItem.getItemOnCursor()));
                guildPlayerItem2.setCreateTime(new Date());
                guildPlayerItems.add(guildPlayerItem2);
            }
            int i = GuildPlayerItemService.getInstance().addAll(guildPlayerItems);
            MessageUtil.sendConsoleDebugMessage("\u672c\u6b21\u88c5\u5907 \u5907\u4efd\u6570\u91cf:" + i);
        });
    }

    public static void setPlayerItemStack(Player player) {
        ItemStack itemOnCursor;
        ItemStack[] extraContents;
        ItemStack[] armorContents;
        if (ConfigUtil.KIT_PVP_CONFIG == null || !ConfigUtil.KIT_PVP_CONFIG.getBoolean("equipment", false) || VersionCheckEnum.getEnum().getVersionId() < VersionCheckEnum.V_1_9.getVersionId()) {
            return;
        }
        UUID playerUniqueId = player.getUniqueId();
        PlayerItem playerItem = PLAYER_ITEM_MAP.get(playerUniqueId);
        if (playerItem == null) {
            return;
        }
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.clear();
        player.setItemOnCursor(new ItemStack(Material.AIR));
        ItemStack[] storageContents = playerItem.getStorageContents();
        if (storageContents != null && storageContents.length > 0) {
            playerInventory.setStorageContents(storageContents);
        }
        if ((armorContents = playerItem.getArmorContents()) != null && armorContents.length > 0) {
            playerInventory.setArmorContents(armorContents);
        }
        if ((extraContents = playerItem.getExtraContents()) != null && extraContents.length > 0) {
            playerInventory.setExtraContents(extraContents);
        }
        if ((itemOnCursor = playerItem.getItemOnCursor()) != null && !Material.AIR.equals((Object)itemOnCursor.getType())) {
            player.setItemOnCursor(itemOnCursor);
        }
        GuildPlayerItemService.getInstance().delByPlayerName(player.getName());
        PLAYER_ITEM_MAP.remove(playerUniqueId);
        player.updateInventory();
    }
}

