/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.core;

import cn.handyplus.top.PlayerTop;
import cn.handyplus.top.constants.PlayerTopTypeEnum;
import cn.handyplus.top.enter.TopPapiPlayer;
import cn.handyplus.top.hook.JobUtil;
import cn.handyplus.top.hook.McMmoUtil;
import cn.handyplus.top.hook.PlaceholderApiUtil;
import cn.handyplus.top.hook.PlayerGuildUtil;
import cn.handyplus.top.hook.PlayerPointsUtil;
import cn.handyplus.top.hook.PlayerTaskUtil;
import cn.handyplus.top.hook.PlayerTitleUtil;
import cn.handyplus.top.hook.VaultUtil;
import cn.handyplus.top.lib.constants.BaseConstants;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.core.NumberUtil;
import cn.handyplus.top.lib.core.StrUtil;
import cn.handyplus.top.lib.util.HandyConfigUtil;
import cn.handyplus.top.lib.util.MessageUtil;
import cn.handyplus.top.util.ConfigUtil;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.MemorySection;

public class AsyncTask {
    public static List<OfflinePlayer> getOnlineList() {
        return new ArrayList<OfflinePlayer>(Bukkit.getOnlinePlayers());
    }

    public static List<OfflinePlayer> getOfflineList() {
        OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
        ArrayList<OfflinePlayer> playerList = new ArrayList<OfflinePlayer>(offlinePlayers.length);
        Collections.addAll(playerList, offlinePlayers);
        return playerList;
    }

    public static List<TopPapiPlayer> supplyOfflineAsync(List<OfflinePlayer> playerList) {
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        if (CollUtil.isEmpty(playerList)) {
            return topPapiPlayerList;
        }
        boolean isOp = ConfigUtil.CONFIG.getBoolean("isOp");
        if (isOp) {
            playerList = playerList.stream().filter(s -> !s.isOp()).collect(Collectors.toList());
        }
        playerList = playerList.stream().filter(s -> StrUtil.isNotEmpty(s.getName())).collect(Collectors.toList());
        List blacklist = ConfigUtil.CONFIG.getStringList("blacklist");
        if (CollUtil.isNotEmpty(blacklist)) {
            playerList = playerList.stream().filter(s -> !blacklist.contains(s.getName())).collect(Collectors.toList());
        }
        ArrayList<CompletableFuture<List>> completableFutureList = new ArrayList<CompletableFuture<List>>();
        for (List<Object> list : CollUtil.splitList(playerList, 1000)) {
            CompletableFuture<List> completableFuture = CompletableFuture.supplyAsync(() -> AsyncTask.getTopPapiPlayerList(players));
            completableFutureList.add(completableFuture);
        }
        if (CollUtil.isEmpty(completableFutureList)) {
            return topPapiPlayerList;
        }
        for (CompletableFuture completableFuture : completableFutureList) {
            topPapiPlayerList.addAll((Collection)completableFuture.join());
        }
        return topPapiPlayerList;
    }

    public static List<String> getOpUidList() {
        ArrayList opList = new ArrayList(Bukkit.getOperators());
        return opList.stream().map(s -> s.getUniqueId().toString()).collect(Collectors.toList());
    }

    private static List<TopPapiPlayer> getTopPapiPlayerList(List<OfflinePlayer> offlinePlayers) {
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        topPapiPlayerList.addAll(AsyncTask.supplyAsyncApi(offlinePlayers));
        topPapiPlayerList.addAll(AsyncTask.supplyAsyncPapi(offlinePlayers));
        return topPapiPlayerList;
    }

    private static List<TopPapiPlayer> supplyAsyncApi(List<OfflinePlayer> offlinePlayers) {
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        Map<String, String> enableMap = HandyConfigUtil.getStringMapChild(ConfigUtil.CONFIG, "enable");
        ArrayList<CompletableFuture<List>> completableFutureList = new ArrayList<CompletableFuture<List>>();
        for (String string : enableMap.keySet()) {
            PlayerTopTypeEnum typeEnum;
            if (!"true".equalsIgnoreCase(enableMap.get(string)) || (typeEnum = PlayerTopTypeEnum.getType(string)) == null) continue;
            CompletableFuture<List> completableFuture = CompletableFuture.supplyAsync(() -> AsyncTask.getApiValue(offlinePlayers, typeEnum));
            completableFutureList.add(completableFuture);
        }
        if (CollUtil.isEmpty(completableFutureList)) {
            return topPapiPlayerList;
        }
        for (CompletableFuture completableFuture : completableFutureList) {
            topPapiPlayerList.addAll((Collection)completableFuture.join());
        }
        return topPapiPlayerList;
    }

    private static List<TopPapiPlayer> supplyAsyncPapi(List<OfflinePlayer> offlinePlayers) {
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        HashMap<String, CompletableFuture<List>> completableFutureMap = new HashMap<String, CompletableFuture<List>>();
        Map<String, String> papiMap = AsyncTask.getPapiMap();
        for (String papiType : papiMap.keySet()) {
            CompletableFuture<List> completableFuture = CompletableFuture.supplyAsync(() -> AsyncTask.getPapiValue(offlinePlayers, papiType, (String)papiMap.get(papiType)));
            completableFutureMap.put(papiType, completableFuture);
        }
        if (completableFutureMap.isEmpty()) {
            return topPapiPlayerList;
        }
        for (String papiType : completableFutureMap.keySet()) {
            try {
                topPapiPlayerList.addAll((Collection)((CompletableFuture)completableFutureMap.get(papiType)).get(2L, TimeUnit.MINUTES));
            }
            catch (Exception exception) {
                MessageUtil.sendConsoleMessage("\u83b7\u53d6" + papiType + "\u53d8\u91cf\u6570\u636e\u8d85\u65f6...");
                if (!BaseConstants.DEBUG) continue;
                exception.printStackTrace();
            }
        }
        return topPapiPlayerList;
    }

    private static List<TopPapiPlayer> getPapiValue(List<OfflinePlayer> offlinePlayers, String papiType, String sort) {
        long start = System.currentTimeMillis();
        MessageUtil.sendConsoleDebugMessage("\u83b7\u53d6" + papiType + "\u53d8\u91cf\u7684\u503c\u5f00\u59cb..");
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        for (OfflinePlayer offlinePlayer : offlinePlayers) {
            Optional<BigDecimal> numericToBigDecimal;
            TopPapiPlayer topPapiPlayer = new TopPapiPlayer();
            topPapiPlayer.setPlayerName(offlinePlayer.getName());
            topPapiPlayer.setPlayerUuid(offlinePlayer.getUniqueId().toString());
            topPapiPlayer.setPapi(papiType);
            topPapiPlayer.setSort(sort);
            String papiValue = PlaceholderApiUtil.set(offlinePlayer, papiType);
            MessageUtil.sendConsoleDebugMessage("\u83b7\u53d6" + papiType + "\u53d8\u91cf\u7684\u503c\u4e3a:" + papiValue);
            if (StrUtil.isEmpty(papiValue) || !(numericToBigDecimal = NumberUtil.isNumericToBigDecimal(papiValue)).isPresent()) continue;
            topPapiPlayer.setVault(numericToBigDecimal.get());
            topPapiPlayerList.add(topPapiPlayer);
        }
        MessageUtil.sendConsoleDebugMessage("\u83b7\u53d6" + papiType + "\u53d8\u91cf\u7684\u503c\u7ed3\u675f,\u8017\u65f6ms:" + (System.currentTimeMillis() - start));
        return topPapiPlayerList;
    }

    private static List<TopPapiPlayer> getApiValue(List<OfflinePlayer> offlinePlayers, PlayerTopTypeEnum typeEnum) {
        long start = System.currentTimeMillis();
        MessageUtil.sendConsoleDebugMessage("\u83b7\u53d6" + typeEnum.getType() + "\u53d8\u91cf\u7684\u503c\u5f00\u59cb..");
        ArrayList<TopPapiPlayer> topPapiPlayerList = new ArrayList<TopPapiPlayer>();
        for (OfflinePlayer offlinePlayer : offlinePlayers) {
            TopPapiPlayer topPapiPlayer = new TopPapiPlayer();
            topPapiPlayer.setPlayerName(offlinePlayer.getName());
            topPapiPlayer.setPlayerUuid(offlinePlayer.getUniqueId().toString());
            topPapiPlayer.setPapi(typeEnum.getType());
            topPapiPlayer.setSort("desc");
            topPapiPlayer.setVault(AsyncTask.getDataValue(offlinePlayer, typeEnum));
            topPapiPlayerList.add(topPapiPlayer);
        }
        MessageUtil.sendConsoleDebugMessage("\u83b7\u53d6" + typeEnum.getType() + "\u53d8\u91cf\u7684\u503c\u7ed3\u675f,\u8017\u65f6ms:" + (System.currentTimeMillis() - start));
        return topPapiPlayerList;
    }

    private static BigDecimal getDataValue(OfflinePlayer offlinePlayer, PlayerTopTypeEnum typeEnum) {
        Long dataValue = 0L;
        if (typeEnum.getType().contains("mcMmo") && !PlayerTop.USE_MC_MMO) {
            return BigDecimal.ZERO;
        }
        if (typeEnum.getType().contains("jobs") && !PlayerTop.USE_JOB) {
            return BigDecimal.ZERO;
        }
        switch (typeEnum) {
            case VAULT: {
                dataValue = VaultUtil.getInstance().getPlayerVault(offlinePlayer);
                break;
            }
            case PLAYER_POINTS: {
                dataValue = PlayerPointsUtil.getInstance().getPlayerPoints(offlinePlayer.getUniqueId());
                break;
            }
            case PLAYER_TITLE_COIN: {
                dataValue = PlayerTitleUtil.getInstance().getPlayerTitleCoin(offlinePlayer.getName());
                break;
            }
            case PLAYER_TITLE_NUMBER: {
                dataValue = PlayerTitleUtil.getInstance().getPlayerTitleNumber(offlinePlayer.getName());
                break;
            }
            case PLAYER_TASK_COIN: {
                dataValue = PlayerTaskUtil.getInstance().getPlayerTaskCoin(offlinePlayer.getName());
                break;
            }
            case PLAYER_GUILD_MONEY: {
                dataValue = PlayerGuildUtil.getInstance().getPlayerGuildMoney(offlinePlayer.getName());
                break;
            }
            case PLAYER_GUILD_DONATED_MONEY: {
                dataValue = PlayerGuildUtil.getInstance().getPlayerDonatedGuildMoney(offlinePlayer.getName());
                break;
            }
            case PLAYER_GUILD_KILL: {
                dataValue = PlayerGuildUtil.getInstance().getPlayerGuildKill(offlinePlayer.getName());
                break;
            }
            case PLAYER_GUILD_DIE: {
                dataValue = PlayerGuildUtil.getInstance().getPlayerGuildDie(offlinePlayer.getName());
                break;
            }
            case MC_MMO: {
                dataValue = McMmoUtil.getInstance().getPowerLevelOffline(offlinePlayer.getUniqueId());
                break;
            }
            case MC_MMO_AXES: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.AXES.name());
                break;
            }
            case MC_MMO_MINING: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.MINING.name());
                break;
            }
            case MC_MMO_REPAIR: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.REPAIR.name());
                break;
            }
            case MC_MMO_SWORDS: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.SWORDS.name());
                break;
            }
            case MC_MMO_TAMING: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.TAMING.name());
                break;
            }
            case MC_MMO_ALCHEMY: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.ALCHEMY.name());
                break;
            }
            case MC_MMO_ARCHERY: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.ARCHERY.name());
                break;
            }
            case MC_MMO_FISHING: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.FISHING.name());
                break;
            }
            case MC_MMO_SALVAGE: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.SALVAGE.name());
                break;
            }
            case MC_MMO_UNARMED: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.UNARMED.name());
                break;
            }
            case MC_MMO_SMELTING: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.SMELTING.name());
                break;
            }
            case MC_MMO_HERBALISM: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.HERBALISM.name());
                break;
            }
            case MC_MMO_ACROBATICS: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.ACROBATICS.name());
                break;
            }
            case MC_MMO_EXCAVATION: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.EXCAVATION.name());
                break;
            }
            case MC_MMO_WOODCUTTING: {
                dataValue = McMmoUtil.getInstance().getLevelOffline(offlinePlayer.getUniqueId(), PrimarySkillType.WOODCUTTING.name());
                break;
            }
            case JOBS_BUILDER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_BREWER.getOriginalType(), 0L);
                break;
            }
            case JOBS_CRAFTER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_CRAFTER.getOriginalType(), 0L);
                break;
            }
            case JOBS_DIGGER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_DIGGER.getOriginalType(), 0L);
                break;
            }
            case JOBS_ENCHANTER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_ENCHANTER.getOriginalType(), 0L);
                break;
            }
            case JOBS_EXPLORER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_EXPLORER.getOriginalType(), 0L);
                break;
            }
            case JOBS_FARMER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_FARMER.getOriginalType(), 0L);
                break;
            }
            case JOBS_FISHERMAN: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_FISHERMAN.getOriginalType(), 0L);
                break;
            }
            case JOBS_HUNTER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_HUNTER.getOriginalType(), 0L);
                break;
            }
            case JOBS_MINER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_MINER.getOriginalType(), 0L);
                break;
            }
            case JOBS_WEAPON_SMITH: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_WEAPON_SMITH.getOriginalType(), 0L);
                break;
            }
            case JOBS_WOODCUTTER: {
                Map<String, Long> jobLevelMap = JobUtil.getInstance().getLevelMap(offlinePlayer.getUniqueId());
                dataValue = jobLevelMap.getOrDefault(PlayerTopTypeEnum.JOBS_WOODCUTTER.getOriginalType(), 0L);
                break;
            }
        }
        return BigDecimal.valueOf(dataValue);
    }

    private static Map<String, String> getPapiMap() {
        Map<String, Object> values = ConfigUtil.getPapiOneChildMap();
        if (values.isEmpty()) {
            return new HashMap<String, String>();
        }
        Map<String, String> papiTypeList = AsyncTask.getPapiTypeList(values);
        if (papiTypeList.isEmpty()) {
            return new HashMap<String, String>();
        }
        return papiTypeList;
    }

    private static Map<String, String> getPapiTypeList(Map<String, Object> values) {
        HashMap<String, String> papiTypeMap = new HashMap<String, String>();
        for (String type : values.keySet()) {
            boolean enable;
            MemorySection memorySection = (MemorySection)values.get(type);
            if (memorySection == null || !(enable = memorySection.getBoolean("enable"))) continue;
            String papi = memorySection.getString("papi", "");
            String sort = memorySection.getString("sort", "desc");
            if (!StrUtil.isNotEmpty(papi)) continue;
            papiTypeMap.put(papi, sort);
        }
        return papiTypeMap;
    }
}

