/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.lib.core;

import cn.handyplus.top.lib.InitApi;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.core.MapUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClassUtil {
    private static final String CLASS = ".class";
    private final File FILE;
    private final ClassLoader CLASS_LOADER = InitApi.PLUGIN.getClass().getClassLoader();

    public ClassUtil() {
        try {
            this.FILE = new File(URLDecoder.decode(InitApi.PLUGIN.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException ignored) {
            throw new NullPointerException("\u52a0\u8f7d\u5f02\u5e38...");
        }
    }

    public List<Class<?>> getClassByAnnotation(String packageName, Class<? extends Annotation> annotation) {
        ArrayList classList = new ArrayList();
        URL jar = this.FILE.toURI().toURL();
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jar}, this.CLASS_LOADER);){
            JarEntry nextJarEntry;
            JarInputStream jarInputStream = new JarInputStream(jar.openStream());
            while ((nextJarEntry = jarInputStream.getNextJarEntry()) != null) {
                String cname;
                Class<?> loadClass;
                String name = this.getName(nextJarEntry);
                if (name == null || !name.startsWith(packageName) || !(loadClass = urlClassLoader.loadClass(cname = name.substring(0, name.lastIndexOf(CLASS)))).isAnnotationPresent(annotation)) continue;
                classList.add(loadClass);
            }
        }
        return classList;
    }

    public Map<Class<?>, List<Method>> getMethodByAnnotation(String packageName, Class<? extends Annotation> annotation) {
        HashMap<Class<?>, List<Method>> map = MapUtil.of();
        URL jar = this.FILE.toURI().toURL();
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jar}, this.CLASS_LOADER);){
            JarEntry nextJarEntry;
            JarInputStream jarInputStream = new JarInputStream(jar.openStream());
            while ((nextJarEntry = jarInputStream.getNextJarEntry()) != null) {
                String name = this.getName(nextJarEntry);
                if (name == null || !name.startsWith(packageName)) continue;
                ArrayList methods = new ArrayList();
                String cname = name.substring(0, name.lastIndexOf(CLASS));
                Class<?> loadClass = urlClassLoader.loadClass(cname);
                Method[] declaredMethods = loadClass.getDeclaredMethods();
                List subCommandMethods = Stream.of(declaredMethods).filter(method -> method.isAnnotationPresent(annotation)).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(subCommandMethods)) {
                    methods.addAll(subCommandMethods);
                }
                map.put(loadClass, methods);
            }
        }
        return map;
    }

    public <T> List<Class<T>> getClassByIsAssignableFrom(String packageName, Class<? extends T> clazz) {
        ArrayList<Class<T>> classList = new ArrayList<Class<T>>();
        URL jar = this.FILE.toURI().toURL();
        try (URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{jar}, this.CLASS_LOADER);){
            JarEntry nextJarEntry;
            JarInputStream jarInputStream = new JarInputStream(jar.openStream());
            while ((nextJarEntry = jarInputStream.getNextJarEntry()) != null) {
                String cname;
                Class<?> loadClass;
                String name = this.getName(nextJarEntry);
                if (name == null || !name.startsWith(packageName) || !clazz.isAssignableFrom(loadClass = urlClassLoader.loadClass(cname = name.substring(0, name.lastIndexOf(CLASS))))) continue;
                classList.add(loadClass);
            }
        }
        return classList;
    }

    private String getName(JarEntry jarEntry) {
        String name = jarEntry.getName();
        if (name.isEmpty()) {
            return null;
        }
        if (!name.endsWith(CLASS)) {
            return null;
        }
        return name.replace("/", ".");
    }
}

