/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.top.service;

import cn.handyplus.top.core.AsyncTask;
import cn.handyplus.top.enter.TopPapiPlayer;
import cn.handyplus.top.lib.core.CollUtil;
import cn.handyplus.top.lib.db.Compare;
import cn.handyplus.top.lib.db.Db;
import cn.handyplus.top.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TopPapiPlayerService {
    private TopPapiPlayerService() {
    }

    public static TopPapiPlayerService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void replace(List<TopPapiPlayer> topPapiPlayerList) {
        if (CollUtil.isEmpty(topPapiPlayerList)) {
            return;
        }
        ArrayList<String> opUidList = new ArrayList<String>();
        boolean isOp = ConfigUtil.CONFIG.getBoolean("isOp");
        if (isOp) {
            opUidList.addAll(AsyncTask.getOpUidList());
        }
        List blacklist = ConfigUtil.CONFIG.getStringList("blacklist");
        List filterList = ConfigUtil.CONFIG.getLongList("filter");
        ArrayList<TopPapiPlayer> saveTopPapiPlayerList = new ArrayList<TopPapiPlayer>();
        Map<String, List<TopPapiPlayer>> topPapiPlayerGroupList = topPapiPlayerList.stream().collect(Collectors.groupingBy(TopPapiPlayer::getPapi));
        for (String string : topPapiPlayerGroupList.keySet()) {
            List<TopPapiPlayer> papiList = topPapiPlayerGroupList.get(string);
            papiList = CollUtil.isNotEmpty(filterList) ? papiList.stream().filter(s -> !filterList.contains(s.getVault())).collect(Collectors.toList()) : papiList;
            List<String> playerUuidList = papiList.stream().map(TopPapiPlayer::getPlayerUuid).distinct().collect(Collectors.toList());
            playerUuidList.addAll(opUidList);
            List<TopPapiPlayer> offTopPapiPlayerList = this.findByPlayerUuids(playerUuidList, blacklist, string, filterList);
            papiList.addAll(offTopPapiPlayerList);
            if (CollUtil.isEmpty(papiList)) continue;
            if ("desc".equalsIgnoreCase(papiList.get(0).getSort())) {
                papiList = papiList.stream().peek(player -> player.setSort("desc")).collect(Collectors.toList());
                papiList = papiList.stream().sorted(Comparator.comparing(TopPapiPlayer::getVault).reversed()).collect(Collectors.toList());
            } else {
                papiList = papiList.stream().peek(player -> player.setSort("asc")).collect(Collectors.toList());
                papiList = papiList.stream().sorted(Comparator.comparing(TopPapiPlayer::getVault)).collect(Collectors.toList());
            }
            for (int i = 0; i < papiList.size(); ++i) {
                papiList.get(i).setRank(i + 1);
            }
            saveTopPapiPlayerList.addAll(papiList);
        }
        this.delete();
        if (CollUtil.isEmpty(saveTopPapiPlayerList)) {
            return;
        }
        for (int i = 0; i < saveTopPapiPlayerList.size(); ++i) {
            ((TopPapiPlayer)saveTopPapiPlayerList.get(i)).setId(i + 1);
        }
        for (List<TopPapiPlayer> list : CollUtil.splitList(saveTopPapiPlayerList, 1000)) {
            this.addBatch(list);
        }
    }

    public List<TopPapiPlayer> page(String papi, Integer pageNum, Integer pageSize) {
        Db<TopPapiPlayer> db = Db.use(TopPapiPlayer.class);
        Compare<TopPapiPlayer> where = db.where();
        where.limit(pageNum, pageSize).eq(TopPapiPlayer::getPapi, papi);
        where.orderByAsc(TopPapiPlayer::getRank);
        return db.execution().page().getRecords();
    }

    public Optional<TopPapiPlayer> findByUidAndType(String uuid, String type) {
        Db<TopPapiPlayer> db = Db.use(TopPapiPlayer.class);
        db.where().eq(TopPapiPlayer::getPlayerUuid, uuid).eq(TopPapiPlayer::getPapi, type);
        return db.execution().selectOne();
    }

    public Optional<TopPapiPlayer> findByRankAndType(Integer rank, String type) {
        Db<TopPapiPlayer> db = Db.use(TopPapiPlayer.class);
        db.where().eq(TopPapiPlayer::getRank, rank).eq(TopPapiPlayer::getPapi, type);
        return db.execution().selectOne();
    }

    private void addBatch(List<TopPapiPlayer> topPapiPlayerList) {
        Db.use(TopPapiPlayer.class).execution().insertBatch(topPapiPlayerList);
    }

    private void delete() {
        Db.use(TopPapiPlayer.class).execution().delete();
    }

    public int deleteByPapi(String papi) {
        Db<TopPapiPlayer> use = Db.use(TopPapiPlayer.class);
        use.where().eq(TopPapiPlayer::getPapi, papi);
        return use.execution().delete();
    }

    public List<TopPapiPlayer> findByPlayerUuids(List<String> playerUuidList, List<String> blackNameList, String papi, List<Long> filterList) {
        Db<TopPapiPlayer> db = Db.use(TopPapiPlayer.class);
        db.where().notIn(CollUtil.isNotEmpty(playerUuidList), TopPapiPlayer::getPlayerUuid, playerUuidList).notIn(CollUtil.isNotEmpty(blackNameList), TopPapiPlayer::getPlayerName, blackNameList).notIn(CollUtil.isNotEmpty(filterList), TopPapiPlayer::getVault, filterList).eq(TopPapiPlayer::getPapi, papi);
        return db.execution().list();
    }

    private static class SingletonHolder {
        private static final TopPapiPlayerService INSTANCE = new TopPapiPlayerService();

        private SingletonHolder() {
        }
    }
}

