/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.core.SignUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class PlayerCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "player";
    }

    @Override
    public String permission() {
        return "playerTitle.player";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command command, String s, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "player")) {
            case PLAYER_ADD_TITLE: {
                PlayerCommand.addTitle(args, sender);
                break;
            }
            case PLAYER_SET_TITLE: {
                PlayerCommand.setTitle(args, sender);
                break;
            }
            case PLAYER_LIST_TITLE: {
                this.listTitle(args, sender);
                break;
            }
            case PLAYER_DELETE_TITLE: {
                PlayerCommand.deleteTitle(args, sender);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("typeFailureMsg"));
            }
        }
    }

    private static void deleteTitle(String[] args, CommandSender sender) {
        boolean rst;
        Integer titleId = NumberUtil.isNumericToInt(args[2]);
        AssertUtil.notNull(titleId, sender, ConfigUtil.LANG_CONFIG.getString("amountFailureMsg"));
        String playerName = null;
        if (args.length > 3) {
            playerName = args[3];
        }
        MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString((rst = TitlePlayerService.getInstance().removeByTitleIdAndPlayerName(titleId, playerName)) ? "succeedMsg" : "failureMsg"));
    }

    private void listTitle(String[] args, CommandSender sender) {
        AssertUtil.notTrue(args.length < 3, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        List<TitlePlayer> titlePlayerList = TitlePlayerService.getInstance().findByPlayerName(args[2]);
        AssertUtil.notNull(titlePlayerList, sender, BaseUtil.getMsgNotColor("listTitle.noTitleFailureMsg"));
        MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("listTitle.titleList"));
        for (TitlePlayer titlePlayer : titlePlayerList) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("listTitle.id") + titlePlayer.getTitleId() + "   " + BaseUtil.getMsgNotColor("listTitle.titleName") + titlePlayer.getTitleName());
        }
    }

    private static void setTitle(String[] args, CommandSender sender) {
        Integer id1;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer titleId = NumberUtil.isNumericToInt(args[3]);
        AssertUtil.notNull(titleId, sender, ConfigUtil.LANG_CONFIG.getString("amountFailureMsg"));
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
        AssertUtil.isTrue(titleListOptional.isPresent(), sender, BaseUtil.getMsgNotColor("notIdFailureMsg"));
        TitleList titleList = titleListOptional.get();
        if (!SignUtil.isGenuine() && (id1 = TitleListService.getInstance().findOneHundredCount()) > 0 && titleId >= id1) {
            MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("currlimig"));
            return;
        }
        Integer day = 0;
        if (args.length > 4) {
            day = NumberUtil.isNumericToInt(args[4]);
            AssertUtil.notNull(day, sender, ConfigUtil.LANG_CONFIG.getString("amountFailureMsg"));
        }
        String titleName = titleList.getTitleName();
        TitlePlayer titlePlayer = new TitlePlayer();
        titlePlayer.setPlayerName(args[2]);
        titlePlayer.setTitleId(titleId);
        titlePlayer.setTitleName(titleName);
        titlePlayer.setIsUseShow(false);
        titlePlayer.setIsUseBuff(false);
        titlePlayer.setIsUseParticle(false);
        titlePlayer.setExpirationTime(DateUtil.getDate(day != 0 ? day : 36500));
        boolean rst = TitlePlayerService.getInstance().set(titlePlayer);
        MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString(rst ? "succeedMsg" : "failureMsg"));
    }

    private static void addTitle(String[] args, CommandSender sender) {
        int id;
        int count;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        if (!SignUtil.isGenuine() && (count = TitleListService.getInstance().findCount()) >= 100) {
            MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("currlimig"));
            return;
        }
        TitleList titleList = new TitleList();
        titleList.setBuyType(BuyTypeEnum.NOT.getBuyType());
        titleList.setAmount(0);
        titleList.setDay(0);
        titleList.setIsHide(true);
        String prefixBrackets = ConfigUtil.CONFIG.getString("prefixBrackets");
        String suffixBrackets = ConfigUtil.CONFIG.getString("suffixBrackets");
        titleList.setTitleName(prefixBrackets + args[3] + suffixBrackets);
        if (args.length > 4) {
            Integer day = NumberUtil.isNumericToInt(args[4]);
            if (day == null || day < 0) {
                MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString("amountFailureMsg"));
                return;
            }
            titleList.setDay(day);
        }
        if ((id = TitleListService.getInstance().add(titleList).intValue()) > 0) {
            TitlePlayer titlePlayer = new TitlePlayer();
            titlePlayer.setPlayerName(args[2]);
            titlePlayer.setTitleId(id);
            titlePlayer.setTitleName(titleList.getTitleName());
            titlePlayer.setExpirationTime(DateUtil.getDate(titleList.getDay() != 0 ? titleList.getDay() : 36500));
            titlePlayer.setIsUseShow(false);
            titlePlayer.setIsUseBuff(false);
            titlePlayer.setIsUseParticle(false);
            TitlePlayerService.getInstance().set(titlePlayer);
        }
        MessageUtil.sendMessage(sender, ConfigUtil.LANG_CONFIG.getString(id > 0 ? "succeedMsg" : "failureMsg"));
    }
}

