/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.core.particle;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.constants.DefaultStylesEnum;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import dev.esophose.playerparticles.particles.ParticleEffect;
import dev.esophose.playerparticles.particles.ParticlePair;
import dev.esophose.playerparticles.particles.data.OrdinaryColor;
import dev.esophose.playerparticles.styles.ParticleStyle;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;

public class PlayerParticlesUtil {
    private PlayerParticlesUtil() {
    }

    public static PlayerParticlesUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void addAttribute(Player player, TitleParticle titleParticle) {
        if (PlayerTitle.PP_API == null) {
            return;
        }
        ParticleEffect particleEffect = ParticleEffect.fromInternalName((String)titleParticle.getWingColor());
        MessageUtil.sendConsoleDebugMessage("\u7c92\u5b50\u6548\u679c\u4e3a:" + particleEffect.getName());
        ParticleStyle defaultStyle = DefaultStylesEnum.getDefaultStyle(titleParticle.getWingContour());
        MessageUtil.sendConsoleDebugMessage("\u7c92\u5b50\u98ce\u683c\u4e3a:" + defaultStyle.getName());
        if (StrUtil.isNotEmpty(titleParticle.getWingThirdColor())) {
            OrdinaryColor color;
            if ("RAINBOW".equalsIgnoreCase(titleParticle.getWingThirdColor())) {
                color = OrdinaryColor.RAINBOW;
            } else if ("RANDOM".equalsIgnoreCase(titleParticle.getWingThirdColor())) {
                color = OrdinaryColor.RANDOM;
            } else {
                List<Integer> rgbList = StrUtil.strToIntList(titleParticle.getWingThirdColor());
                if (rgbList.size() != 3) {
                    MessageUtil.sendConsoleDebugMessage("\u7c92\u5b50\u989c\u8272\u6548\u679c\u8bbe\u7f6e\u9519\u8bef:" + titleParticle.getWingThirdColor());
                    PlayerTitle.PP_API.addActivePlayerParticle(player, particleEffect, defaultStyle);
                    return;
                }
                color = new OrdinaryColor(rgbList.get(0).intValue(), rgbList.get(1).intValue(), rgbList.get(2).intValue());
            }
            PlayerTitle.PP_API.addActivePlayerParticle(player, particleEffect, defaultStyle, color);
        } else {
            PlayerTitle.PP_API.addActivePlayerParticle(player, particleEffect, defaultStyle);
        }
    }

    public void removeAttribute(Player player) {
        if (PlayerTitle.PP_API == null) {
            return;
        }
        Collection activePlayerParticles = PlayerTitle.PP_API.getActivePlayerParticles(player);
        if (activePlayerParticles.isEmpty()) {
            return;
        }
        for (ParticlePair activePlayerParticle : activePlayerParticles) {
            PlayerTitle.PP_API.removeActivePlayerParticle(player, activePlayerParticle.getId());
        }
    }

    private static class SingletonHolder {
        private static final PlayerParticlesUtil INSTANCE = new PlayerParticlesUtil();

        private SingletonHolder() {
        }
    }
}

