/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.lib.util;

import com.handy.playertitle.lib.InitApi;
import com.handy.playertitle.lib.constants.BaseConstants;
import com.handy.playertitle.lib.constants.VersionCheckEnum;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.XMaterial;
import com.handy.playertitle.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static String itemStackSerialize(ItemStack itemStack) {
        YamlConfiguration yml = new YamlConfiguration();
        yml.set("item", (Object)itemStack);
        return yml.saveToString();
    }

    public static ItemStack itemStackDeserialize(String str) {
        return ItemStackUtil.itemStackDeserialize(str, Material.AIR);
    }

    public static ItemStack itemStackDeserialize(String str, Material material) {
        ItemStack item;
        YamlConfiguration yml = new YamlConfiguration();
        try {
            yml.loadFromString(str);
            item = yml.getItemStack("item", new ItemStack(material));
        }
        catch (Exception ex) {
            item = new ItemStack(material);
        }
        return item;
    }

    public static ItemStack getItemStack(String material) {
        return ItemStackUtil.getItemStack(material, null, null);
    }

    public static ItemStack getItemStack(String material, String displayName) {
        return ItemStackUtil.getItemStack(material, displayName, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, false);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, 0);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, true);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData, boolean hideFlag) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, Boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, true);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant) {
        return ItemStackUtil.getItemStack(material, displayName, loreList, isEnchant, customModelData, hideFlag, replaceMap, hideEnchant, null);
    }

    public static ItemStack getItemStack(String material, String displayName, List<String> loreList, boolean isEnchant, int customModelData, boolean hideFlag, Map<String, String> replaceMap, boolean hideEnchant, String customData) {
        ItemStack itemStack = ItemStackUtil.getItemByMaterial(material);
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        if (StrUtil.isNotEmpty(displayName)) {
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(displayName));
        }
        if (CollUtil.isNotEmpty(loreList)) {
            itemMeta.setLore(BaseUtil.replaceChatColor(ItemStackUtil.loreReplaceMap(loreList, replaceMap)));
        }
        if (isEnchant) {
            ItemStackUtil.setEnchant(itemMeta);
        }
        if (hideEnchant) {
            ItemStackUtil.hideEnchant(itemMeta);
        }
        if (hideFlag) {
            ItemStackUtil.hideAttributes(itemMeta);
        }
        if (StrUtil.isNotEmpty(customData)) {
            ItemStackUtil.setPersistentData(itemMeta, customData, "system");
        }
        if (customModelData > 0) {
            ItemStackUtil.setCustomModelData(itemMeta, customModelData);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static void setEnchant(ItemMeta itemMeta) {
        itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
    }

    public static void hideEnchant(ItemMeta itemMeta) {
        if (!VersionCheckEnum.V_1_7.equals((Object)BaseConstants.VERSION_CHECK_ENUM)) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
    }

    public static void hideAttributes(ItemMeta itemMeta) {
        if (!VersionCheckEnum.V_1_7.equals((Object)BaseConstants.VERSION_CHECK_ENUM)) {
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
    }

    public static Boolean removeItem(PlayerInventory playerInventory, ItemStack itemStack, Integer amount) {
        return ItemStackUtil.removeItem(playerInventory, itemStack, amount, true);
    }

    public static Boolean removeItem(PlayerInventory playerInventory, ItemStack itemStack, Integer amount, boolean strict) {
        ItemStack[] contents = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int num = 0;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : contents) {
            if (item == null || Material.AIR.equals((Object)item.getType()) || (strict ? !item.isSimilar(itemStack) : !ItemStackUtil.isSimilar(item, itemStack))) continue;
            items.add(item);
            if ((num += item.getAmount()) >= amount) break;
        }
        if (num == amount) {
            for (ItemStack item : items) {
                playerInventory.removeItem(new ItemStack[]{item});
            }
            return true;
        }
        if (num > amount) {
            for (ItemStack item : items) {
                if (amount == 0) {
                    return true;
                }
                if (amount >= item.getAmount()) {
                    amount = amount - item.getAmount();
                    playerInventory.removeItem(new ItemStack[]{item});
                    continue;
                }
                item.setAmount(item.getAmount() - amount);
                amount = 0;
            }
            return true;
        }
        return false;
    }

    public static Boolean containsItem(PlayerInventory playerInventory, ItemStack itemStack, Integer amount, boolean strict) {
        ItemStack[] contents = BaseConstants.VERSION_ID <= VersionCheckEnum.V_1_8.getVersionId() ? playerInventory.getContents() : playerInventory.getStorageContents();
        int num = 0;
        for (ItemStack item : contents) {
            if (item != null && !Material.AIR.equals((Object)item.getType()) && !(!strict ? !ItemStackUtil.isSimilar(item, itemStack) : !item.isSimilar(itemStack)) && (num += item.getAmount()) >= amount) break;
        }
        return num >= amount;
    }

    public static void addItem(PlayerInventory playerInventory, ItemStack itemStack, int amount) {
        int maxStackSize = itemStack.getMaxStackSize();
        if (amount > maxStackSize) {
            itemStack.setAmount(maxStackSize);
            playerInventory.addItem(new ItemStack[]{itemStack});
            ItemStackUtil.addItem(playerInventory, itemStack, amount - maxStackSize);
        } else {
            itemStack.setAmount(amount);
            playerInventory.addItem(new ItemStack[]{itemStack});
        }
    }

    public static Material getMaterial(String materialStr) {
        return ItemStackUtil.getMaterial(materialStr, Material.STONE);
    }

    public static Material getMaterial(String materialStr, Material defaultMaterial) {
        if (StrUtil.isEmpty(materialStr)) {
            return defaultMaterial;
        }
        Material material = Material.getMaterial((String)(materialStr = materialStr.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)("LEGACY_" + materialStr), (boolean)true)) != null) {
            return material;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return defaultMaterial;
        }
        return XMaterial.matchXMaterial(materialStr).orElse(XMaterial.matchXMaterial(defaultMaterial)).parseMaterial();
    }

    public static ItemStack getItemByMaterial(String materialStr) {
        return ItemStackUtil.getItemByMaterial(materialStr, Material.STONE);
    }

    public static ItemStack getItemByMaterial(String materialStr, Material defaultMaterial) {
        if (StrUtil.isEmpty(materialStr)) {
            return new ItemStack(defaultMaterial);
        }
        Material material = Material.getMaterial((String)(materialStr = materialStr.toUpperCase(Locale.ROOT)));
        if (material != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId() && (material = Material.getMaterial((String)("LEGACY_" + materialStr), (boolean)true)) != null) {
            return new ItemStack(material);
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
            return new ItemStack(defaultMaterial);
        }
        return XMaterial.matchXMaterial(materialStr).orElse(XMaterial.matchXMaterial(defaultMaterial)).parseItem();
    }

    public static ItemStack getItemInMainHand(PlayerInventory playerInventory) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            return playerInventory.getItemInHand();
        }
        return playerInventory.getItemInMainHand();
    }

    public static void setItemInMainHand(PlayerInventory playerInventory, ItemStack itemStack) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_9.getVersionId()) {
            playerInventory.setItemInHand(itemStack);
            return;
        }
        playerInventory.setItemInMainHand(itemStack);
    }

    public static void setCustomModelData(ItemMeta itemMeta, int id) {
        if (itemMeta == null || BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || id == 0) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(id));
    }

    public static ItemMeta getItemMeta(ItemStack itemStack) {
        ItemMeta itemMeta;
        if (itemStack == null) {
            itemStack = new ItemStack(Material.STONE);
        }
        if ((itemMeta = itemStack.getItemMeta()) == null) {
            return new ItemStack(Material.STONE).getItemMeta();
        }
        return itemMeta;
    }

    public static List<String> loreReplaceMap(List<String> loreList, Map<String, String> replaceMap) {
        ArrayList<String> newLoreList = new ArrayList<String>();
        if (replaceMap != null && !replaceMap.isEmpty() && CollUtil.isNotEmpty(loreList)) {
            for (String lore : loreList) {
                for (String key : replaceMap.keySet()) {
                    if (!lore.contains("${" + key + "}") || replaceMap.get(key) == null) continue;
                    lore = StrUtil.replace(lore, key, replaceMap.get(key));
                }
                newLoreList.add(lore);
            }
        } else {
            newLoreList.addAll(loreList);
        }
        return newLoreList;
    }

    public static List<String> loreBatchReplaceMap(List<String> loreList, Map<String, List<String>> replaceMap, String def) {
        if (CollUtil.isEmpty(loreList) || replaceMap == null || replaceMap.isEmpty()) {
            return loreList;
        }
        ArrayList<String> newLoreList = new ArrayList<String>();
        for (String lore : loreList) {
            newLoreList.addAll(ItemStackUtil.loreBatchReplaceMap(lore, replaceMap, def));
        }
        return newLoreList;
    }

    public static List<String> loreBatchReplaceMap(String lore, Map<String, List<String>> replaceMap, String def) {
        ArrayList<String> loreList = new ArrayList<String>();
        if (StrUtil.isEmpty(lore)) {
            loreList.add(lore);
            return loreList;
        }
        if (replaceMap == null || replaceMap.isEmpty()) {
            loreList.add(lore);
            return loreList;
        }
        if (StrUtil.isEmpty(def)) {
            def = "";
        }
        for (String key : replaceMap.keySet()) {
            if (!lore.contains("${" + key + "}")) continue;
            List<String> replaceList = replaceMap.get(key);
            if (CollUtil.isEmpty(replaceList)) {
                loreList.add(StrUtil.replace(lore, key, def));
                break;
            }
            for (String replaceStr : replaceList) {
                loreList.add(StrUtil.replace(lore, key, replaceStr));
            }
        }
        if (CollUtil.isEmpty(loreList)) {
            loreList.add(lore);
        }
        return loreList;
    }

    public static void setPersistentData(ItemStack itemStack, String customData, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemStackUtil.setPersistentData(itemMeta, customData, key);
        itemStack.setItemMeta(itemMeta);
    }

    public static void setPersistentData(ItemMeta itemMeta, String customData, String key) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || itemMeta == null) {
            return;
        }
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        String namespacedKeyStr = "handy_data";
        if (StrUtil.isNotEmpty(key)) {
            namespacedKeyStr = namespacedKeyStr + "_" + key;
        }
        dataContainer.set(new NamespacedKey((Plugin)InitApi.PLUGIN, namespacedKeyStr), PersistentDataType.STRING, (Object)customData);
    }

    public static Optional<String> getPersistentData(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        return ItemStackUtil.getPersistentData(itemMeta, key);
    }

    public static Optional<String> getPersistentData(ItemMeta itemMeta, String key) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_14.getVersionId() || itemMeta == null) {
            return Optional.empty();
        }
        String namespacedKeyStr = "handy_data";
        if (StrUtil.isNotEmpty(key)) {
            namespacedKeyStr = namespacedKeyStr + "_" + key;
        }
        String persistentData = (String)itemMeta.getPersistentDataContainer().get(new NamespacedKey((Plugin)InitApi.PLUGIN, namespacedKeyStr), PersistentDataType.STRING);
        return Optional.ofNullable(persistentData);
    }

    public static boolean isSimilar(ItemStack one, ItemStack two) {
        ItemMeta twoItemMeta;
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (!one.getType().equals((Object)two.getType())) {
            return false;
        }
        ItemMeta oneItemMeta = one.getItemMeta();
        if (oneItemMeta == (twoItemMeta = two.getItemMeta())) {
            return true;
        }
        if (oneItemMeta == null || twoItemMeta == null) {
            return false;
        }
        if (!StrUtil.equals(oneItemMeta.getDisplayName(), twoItemMeta.getDisplayName())) {
            return false;
        }
        return CollUtil.equals(oneItemMeta.getLore(), twoItemMeta.getLore());
    }
}

