/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.inventory.TitleCustomGui;
import com.handy.playertitle.lib.annotation.HandyListener;
import com.handy.playertitle.lib.core.SignUtil;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;

@HandyListener
public class AsyncPlayerChatEventListener
implements Listener {
    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        boolean isChat = ConfigUtil.CONFIG.getBoolean("isChat");
        if (!isChat) {
            return;
        }
        TitlePlayer titlePlayer = TitleConstants.TITLE_PLAYER_SHOW_MAP.get(event.getPlayer().getUniqueId());
        String titleName = ConfigUtil.CONFIG.getString("default");
        if (titlePlayer != null) {
            titleName = titlePlayer.getTitleName();
        }
        titleName = PlaceholderApiUtil.set(event.getPlayer(), titleName);
        titleName = BaseUtil.replaceChatColor(titleName);
        event.setFormat(titleName + ConfigUtil.CONFIG.getString("isChatFormat", " ") + event.getFormat());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onAsyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String msg = TitleConstants.TITLE_CUSTOM_MAP.get(player.getUniqueId());
        if (!"titleCustom".equals(msg)) {
            return;
        }
        event.setCancelled(true);
        String titleName = event.getMessage();
        if ("T".equalsIgnoreCase(titleName)) {
            MessageUtil.sendMessage(player, ConfigUtil.TITLE_CUSTOM_CONFIG.getString("cancelMsh"));
            TitleConstants.TITLE_CUSTOM_MAP.remove(player.getUniqueId());
            return;
        }
        this.titleCustom(player, titleName);
    }

    private void titleCustom(Player player, String titleName) {
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            int count;
            if (!SignUtil.isGenuine() && (count = TitleListService.getInstance().findCount()) >= 100) {
                MessageUtil.sendMessage(player, BaseUtil.getLangMsg("currlimig"));
                return;
            }
            int customLength = ConfigUtil.CONFIG.getInt("customLength", 16);
            String customLengthMsg = BaseUtil.getLangMsg("customLengthMsg", "&8[&c\u2718&8] &7\u79f0\u53f7\u4e0d\u80fd\u8d85\u8fc7&a${len}&7\u5b57\u7b26");
            if (BaseUtil.stripColor(titleName).length() > customLength) {
                MessageUtil.sendMessage(player, StrUtil.replace(customLengthMsg, "len", String.valueOf(customLength)));
                return;
            }
            List nameBlackList = ConfigUtil.TITLE_CUSTOM_CONFIG.getStringList("nameBlackList");
            for (String nameBlack : nameBlackList) {
                if (!titleName.contains(nameBlack)) continue;
                String nameBlackListFailureMsg = ConfigUtil.TITLE_CUSTOM_CONFIG.getString("nameBlackListFailureMsg", "");
                MessageUtil.sendMessage(player, StrUtil.replace(nameBlackListFailureMsg, "name", nameBlack));
                return;
            }
            String prefixBrackets = ConfigUtil.CONFIG.getString("prefixBrackets");
            String suffixBrackets = ConfigUtil.CONFIG.getString("suffixBrackets");
            Inventory inventory = TitleCustomGui.getInstance().createGui(player, prefixBrackets + titleName + suffixBrackets);
            HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEssChat(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (PlayerTitle.USE_PAPI && ConfigUtil.CONFIG.getBoolean("essChat", false)) {
            event.setFormat(BaseUtil.replaceChatColor(PlaceholderAPI.setBracketPlaceholders((Player)event.getPlayer(), (String)event.getFormat())));
        }
    }
}

