/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.google.common.collect.Maps;
import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.inventory.AdminShopGui;
import com.handy.playertitle.inventory.DeleteBuffGui;
import com.handy.playertitle.inventory.HavePlayerGui;
import com.handy.playertitle.inventory.ViewShopGui;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class AdminShopClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.ADMIN_SHOP.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Integer titleId = handyInventory.getId();
        HashMap changeMap = Maps.newHashMapWithExpectedSize((int)2);
        changeMap.put("titleId", titleId);
        changeMap.put("clickRawSlot", event.getRawSlot());
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "delete")) {
            TitleListService.getInstance().removeById(titleId);
            Inventory inventory = ViewShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        Optional<TitleList> titleListOptional = TitleListService.getInstance().findById(titleId);
        if (!titleListOptional.isPresent()) {
            return;
        }
        TitleList titleList = titleListOptional.get();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "status")) {
            TitleListService.getInstance().updateIsHide(titleId, titleList.getIsHide() == false);
            AdminShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "name")) {
            TitleConstants.ADMIN_SHOP_CACHE_MAP.put(player.getUniqueId(), changeMap);
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.changeName"));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "buyType")) {
            TitleConstants.ADMIN_SHOP_CACHE_MAP.put(player.getUniqueId(), changeMap);
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.changeType") + CollUtil.listToStr(BuyTypeEnum.getEnumListNotPermission()));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "item")) {
            TitleConstants.ADMIN_SHOP_CACHE_MAP.put(player.getUniqueId(), changeMap);
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.changeItem"));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "price")) {
            TitleConstants.ADMIN_SHOP_CACHE_MAP.put(player.getUniqueId(), changeMap);
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.changeAmount"));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "day")) {
            TitleConstants.ADMIN_SHOP_CACHE_MAP.put(player.getUniqueId(), changeMap);
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("view.changeDay"));
            handyInventory.syncClose();
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "buff")) {
            Inventory inventory = DeleteBuffGui.getInstance().createGui(player, titleId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "player")) {
            Inventory inventory = HavePlayerGui.getInstance().createGui(player, titleId);
            handyInventory.syncOpen(inventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "particle")) {
            TitleParticleService.getInstance().removeByTitleId(titleId);
            AdminShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "description")) {
            TitleListService.getInstance().updateDescription(titleId, null);
            AdminShopGui.getInstance().setInventoryDate(handyInventory);
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.ADMIN_SHOP_CONFIG, "back")) {
            Inventory inventory = ViewShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
        }
    }
}

