/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.BuyTypeEnum;
import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleCustomEnum;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlayerPointsUtil;
import com.handy.playertitle.hook.VaultUtil;
import com.handy.playertitle.inventory.ShopGui;
import com.handy.playertitle.lib.core.DateUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class TitleCustomClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.TITLE_CUSTOM.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        String titleName = handyInventory.getSearchType();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.TITLE_CUSTOM_CONFIG, "back")) {
            TitleConstants.TITLE_CUSTOM_MAP.remove(player.getUniqueId());
            Inventory inventory = ShopGui.getInstance().createGui(player);
            handyInventory.syncOpen(inventory);
            return;
        }
        boolean rst = false;
        TitleCustomEnum titleCustomEnum = null;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.TITLE_CUSTOM_CONFIG, "point")) {
            int pointPrice = ConfigUtil.TITLE_CUSTOM_CONFIG.getInt("point.price");
            rst = PlayerPointsUtil.buy(player, pointPrice);
            titleCustomEnum = TitleCustomEnum.POINT_CUSTOM;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.TITLE_CUSTOM_CONFIG, "vault")) {
            int vaultPrice = ConfigUtil.TITLE_CUSTOM_CONFIG.getInt("vault.price");
            rst = VaultUtil.buy(player, vaultPrice);
            titleCustomEnum = TitleCustomEnum.VAULT_CUSTOM;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.TITLE_CUSTOM_CONFIG, "coin")) {
            int moneyPrice = ConfigUtil.TITLE_CUSTOM_CONFIG.getInt("coin.price");
            int money = Integer.parseInt(TitleUtil.getTitleCoin(player));
            if (money < moneyPrice) {
                rst = false;
            } else {
                TitleCoinService.getInstance().take(player.getName(), moneyPrice);
                rst = true;
            }
            titleCustomEnum = TitleCustomEnum.COIN_CUSTOM;
        }
        if (!rst) {
            MessageUtil.sendMessage(player, ConfigUtil.TITLE_CUSTOM_CONFIG.getString("notMoneyFailureMsg"));
            return;
        }
        TitleList titleList = new TitleList();
        titleList.setBuyType(BuyTypeEnum.NOT.getBuyType());
        titleList.setAmount(0);
        titleList.setDay(TitleCustomEnum.getEnumToDay(titleCustomEnum));
        titleList.setIsHide(true);
        titleList.setTitleName(titleName);
        int id = TitleListService.getInstance().add(titleList);
        if (id > 0) {
            TitlePlayer titlePlayer = new TitlePlayer();
            titlePlayer.setPlayerName(player.getName());
            titlePlayer.setPlayerUuid(player.getUniqueId().toString());
            titlePlayer.setTitleId(id);
            titlePlayer.setTitleName(titleList.getTitleName());
            titlePlayer.setExpirationTime(DateUtil.getDate(titleList.getDay() != 0 ? titleList.getDay() : 36500));
            titlePlayer.setIsUseShow(false);
            titlePlayer.setIsUseBuff(false);
            titlePlayer.setIsUseParticle(false);
            TitlePlayerService.getInstance().set(titlePlayer);
            MessageUtil.sendMessage(player, ConfigUtil.TITLE_CUSTOM_CONFIG.getString("buyMsg"));
        } else {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("failureMsg"));
        }
        TitleConstants.TITLE_CUSTOM_MAP.remove(player.getUniqueId());
        handyInventory.syncClose();
    }
}

