/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.service;

import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.lib.core.CollUtil;
import com.handy.playertitle.lib.core.MapUtil;
import com.handy.playertitle.lib.db.Db;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TitleBuffService {
    private TitleBuffService() {
    }

    public static TitleBuffService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public Boolean add(TitleBuff titleBuff) {
        return Db.use(TitleBuff.class).execution().insert(titleBuff) > 0;
    }

    public List<TitleBuff> findByTitleId(Integer titleId) {
        Db<TitleBuff> use = Db.use(TitleBuff.class);
        use.where().eq(TitleBuff::getTitleId, titleId);
        return use.execution().list();
    }

    public List<TitleBuff> findByTitleIdList(List<Integer> titleIdList) {
        if (CollUtil.isEmpty(titleIdList)) {
            return new ArrayList<TitleBuff>();
        }
        Db<TitleBuff> use = Db.use(TitleBuff.class);
        use.where().in(TitleBuff::getTitleId, titleIdList);
        return use.execution().list();
    }

    public Map<Integer, List<TitleBuff>> findMapByTitleIdList(List<Integer> titleIdList, List<String> buffTypeList) {
        if (CollUtil.isEmpty(titleIdList)) {
            return MapUtil.of();
        }
        Db<TitleBuff> use = Db.use(TitleBuff.class);
        use.where().in(TitleBuff::getTitleId, titleIdList).in(CollUtil.isNotEmpty(buffTypeList), TitleBuff::getBuffType, buffTypeList);
        List<TitleBuff> titleBuffList = use.execution().list();
        if (CollUtil.isEmpty(titleBuffList)) {
            return MapUtil.of();
        }
        return titleBuffList.stream().collect(Collectors.groupingBy(TitleBuff::getTitleId));
    }

    public Boolean removeByTitleId(Integer titleId) {
        Db<TitleBuff> use = Db.use(TitleBuff.class);
        use.where().eq(TitleBuff::getTitleId, titleId);
        return use.execution().delete() > 0;
    }

    public void removeById(Integer id) {
        Db.use(TitleBuff.class).execution().deleteById(id);
    }

    public List<TitleBuff> findAll() {
        return Db.use(TitleBuff.class).execution().list();
    }

    public void removeAll() {
        Db.use(TitleBuff.class).execution().delete();
    }

    public boolean editById(Integer id, String buffContent) {
        Db<TitleBuff> use = Db.use(TitleBuff.class);
        use.update().set(TitleBuff::getBuffContent, buffContent);
        return use.execution().updateById(id) > 0;
    }

    private static class SingletonHolder {
        private static final TitleBuffService INSTANCE = new TitleBuffService();

        private SingletonHolder() {
        }
    }
}

