/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.util;

import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.hook.PlaceholderApiUtil;
import com.handy.playertitle.lib.constants.VersionCheckEnum;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.util.ConfigUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

public class TitleTabUtil {
    private static Scoreboard board;

    public static void init() {
        boolean isTab = ConfigUtil.CONFIG.getBoolean("isTab");
        if (!isTab || HandySchedulerUtil.isFolia()) {
            return;
        }
        ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
        if (scoreboardManager == null) {
            return;
        }
        board = scoreboardManager.getNewScoreboard();
    }

    public static void setTitleTab(Player player) {
        Team team;
        boolean isTab = ConfigUtil.CONFIG.getBoolean("isTab");
        if (!isTab || HandySchedulerUtil.isFolia()) {
            return;
        }
        TitlePlayer titlePlayer = TitleConstants.TITLE_PLAYER_SHOW_MAP.get(player.getUniqueId());
        String titleName = titlePlayer == null ? ConfigUtil.CONFIG.getString("default", "") : titlePlayer.getTitleName();
        titleName = BaseUtil.replaceChatColor(titleName);
        titleName = PlaceholderApiUtil.set(player, titleName);
        if (VersionCheckEnum.getEnum().getVersionId() < VersionCheckEnum.V_1_13.getVersionId() && titleName.length() > 16) {
            titleName = titleName.substring(0, 16);
        }
        if (VersionCheckEnum.getEnum().getVersionId() >= VersionCheckEnum.V_1_13.getVersionId() && titleName.length() > 64) {
            titleName = titleName.substring(0, 64);
        }
        if ((team = board.getTeam(player.getName())) == null) {
            team = board.registerNewTeam(player.getName());
        }
        team.setPrefix(titleName);
        team.addEntry(player.getName());
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer == null) continue;
            onlinePlayer.setScoreboard(board);
        }
    }

    public static void delTitleTab(Player player) {
        boolean isTab = ConfigUtil.CONFIG.getBoolean("isTab");
        if (!isTab || HandySchedulerUtil.isFolia()) {
            return;
        }
        Team team = board.getTeam(player.getName());
        if (team != null) {
            team.unregister();
        }
    }
}

