/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.commands.interactions.DisguiseCloneInteraction;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCloneCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int i;
        if (sender.getName().equals("CONSOLE")) {
            LibsMsg.NO_CONSOLE.send(sender, new Object[0]);
            return true;
        }
        if (!sender.hasPermission("libsdisguises.disguise.disguiseclone")) {
            LibsMsg.NO_PERM.send(sender, new Object[0]);
            return true;
        }
        boolean doEquipment = true;
        boolean doAdded = false;
        Player player = null;
        if (args.length > 0) {
            player = Bukkit.getPlayerExact((String)args[0]);
        }
        int n = i = player == null ? 0 : 1;
        while (i < args.length) {
            String option = args[i];
            if (StringUtils.startsWithIgnoreCase((String)option, (String)LibsMsg.DCLONE_EQUIP.get(new Object[0]))) {
                doEquipment = false;
            } else if (option.equalsIgnoreCase(LibsMsg.DCLONE_ADDEDANIMATIONS.get(new Object[0]))) {
                doAdded = true;
            } else {
                LibsMsg.INVALID_CLONE.send(sender, option);
                return true;
            }
            ++i;
        }
        Boolean[] options = new Boolean[]{doEquipment, doAdded};
        if (player != null) {
            DisguiseUtilities.createClonedDisguise((Player)sender, (Entity)player, options);
        } else {
            LibsDisguises.getInstance().getListener().addInteraction(sender.getName(), new DisguiseCloneInteraction(options), DisguiseConfig.getDisguiseCloneExpire());
            LibsMsg.CLICK_TIMER.send(sender, DisguiseConfig.getDisguiseCloneExpire());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] origArgs) {
        ArrayList<String> tabs = new ArrayList<String>();
        String[] args = this.getPreviousArgs(origArgs);
        if (args.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (sender instanceof Player && !((Player)sender).canSee(player)) continue;
                tabs.add(player.getName());
            }
        }
        tabs.add(LibsMsg.DCLONE_EQUIP.get(new Object[0]));
        tabs.add(LibsMsg.DCLONE_ADDEDANIMATIONS.get(new Object[0]));
        return this.filterTabs(tabs, origArgs);
    }

    @Override
    protected void sendCommandUsage(CommandSender sender, DisguisePermissions permissions) {
        LibsMsg.CLONE_HELP1.send(sender, new Object[0]);
        LibsMsg.CLONE_HELP2.send(sender, new Object[0]);
        LibsMsg.CLONE_HELP3.send(sender, new Object[0]);
    }
}

