/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodGroupType;
import me.libraryaddict.disguise.utilities.reflection.annotations.MethodOnlyUsedBy;
import me.libraryaddict.disguise.utilities.reflection.annotations.NmsAddedIn;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<String> potionEffects = new HashSet();
    private boolean[] modifiedLivingAnimations = new boolean[3];

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher clone = (LivingWatcher)super.clone(disguise);
        clone.potionEffects = (HashSet)this.potionEffects.clone();
        clone.maxHealth = this.maxHealth;
        clone.maxHealthSet = this.maxHealthSet;
        clone.modifiedLivingAnimations = Arrays.copyOf(this.modifiedLivingAnimations, this.modifiedLivingAnimations.length);
        return clone;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public BlockPosition getBedPosition() {
        return this.getData(MetaIndex.LIVING_BED_POSITION).orElse(null);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBedPosition(BlockPosition blockPosition) {
        Optional<Object> optional = blockPosition != null ? Optional.of(blockPosition) : Optional.empty();
        this.setData(MetaIndex.LIVING_BED_POSITION, optional);
        this.sendData(MetaIndex.LIVING_BED_POSITION);
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public void setHealth(float health) {
        this.setData(MetaIndex.LIVING_HEALTH, Float.valueOf(health));
        this.sendData(MetaIndex.LIVING_HEALTH);
    }

    private boolean getHandFlag(int byteValue) {
        return (this.getData(MetaIndex.LIVING_META) & 1 << byteValue) != 0;
    }

    private void setHandFlag(int byteValue, boolean flag) {
        byte b0 = this.getData(MetaIndex.LIVING_META);
        this.modifiedLivingAnimations[byteValue] = true;
        if (flag) {
            this.setData(MetaIndex.LIVING_META, (byte)(b0 | 1 << byteValue));
        } else {
            this.setData(MetaIndex.LIVING_META, (byte)(b0 & ~(1 << byteValue)));
        }
        this.sendData(MetaIndex.LIVING_META);
    }

    private boolean isMainHandUsed() {
        return !this.getHandFlag(1);
    }

    private void setHandInUse(boolean mainHand) {
        if (this.isMainHandUsed() == mainHand) {
            return;
        }
        this.setHandFlag(1, !mainHand);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isMainHandRaised() {
        return this.isMainHandUsed() && this.getHandFlag(0);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setMainHandRaised(boolean setRightClicking) {
        this.setHandInUse(true);
        this.setHandFlag(0, setRightClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isOffhandRaised() {
        return !this.isMainHandUsed() && this.getHandFlag(0);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setOffhandRaised(boolean setLeftClicking) {
        this.setHandInUse(false);
        this.setHandFlag(0, setLeftClicking);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isSpinning() {
        return this.getHandFlag(2);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setSpinning(boolean setSpinning) {
        this.setHandFlag(2, setSpinning);
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(double newHealth) {
        this.maxHealth = newHealth;
        this.maxHealthSet = true;
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            PacketContainer packet = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            ArrayList<WrappedAttribute> attributes = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder();
            builder.attributeKey(NmsVersion.v1_16.isSupported() ? "generic.max_health" : "generic.maxHealth");
            builder.baseValue(this.getMaxHealth());
            builder.packet(packet);
            attributes.add(builder.build());
            Entity entity = this.getDisguise().getEntity();
            packet.getIntegers().write(0, (Object)entity.getEntityId());
            packet.getAttributeCollectionModifier().write(0, attributes);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                if (player == this.getDisguise().getEntity()) {
                    PacketContainer p = packet.shallowClone();
                    p.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, p, false);
                    continue;
                }
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packet, false);
            }
        }
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public void setPotionParticlesAmbient(boolean particles) {
        this.setData(MetaIndex.LIVING_POTION_AMBIENT, particles);
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public Color getParticlesColor() {
        int color = this.getData(MetaIndex.LIVING_POTIONS);
        return Color.fromRGB((int)color);
    }

    public void setParticlesColor(Color color) {
        this.potionEffects.clear();
        this.setData(MetaIndex.LIVING_POTIONS, color.asRGB());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    private int getPotions() {
        if (this.potionEffects.isEmpty()) {
            return 0;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String typeId : this.potionEffects) {
            Color color;
            PotionEffectType type = PotionEffectType.getByName((String)typeId);
            if (type == null || (color = type.getColor()) == null) continue;
            colors.add(color);
        }
        if (colors.isEmpty()) {
            return 0;
        }
        Color color = (Color)colors.remove(0);
        return color.mixColors(colors.toArray(new Color[0])).asRGB();
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.potionEffects.contains(type.getName());
    }

    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    public PotionEffectType[] getPotionEffects() {
        PotionEffectType[] effects = new PotionEffectType[this.potionEffects.size()];
        int i = 0;
        Iterator<String> itel = this.potionEffects.iterator();
        while (itel.hasNext()) {
            PotionEffectType type = PotionEffectType.getByName((String)itel.next());
            effects[i++] = type;
        }
        return effects;
    }

    public void addPotionEffect(PotionEffectType potionEffect) {
        if (!this.hasPotionEffect(potionEffect)) {
            this.potionEffects.add(potionEffect.getName());
        }
        this.sendPotionEffects();
    }

    public void removePotionEffect(PotionEffectType potionEffect) {
        if (this.hasPotionEffect(potionEffect)) {
            this.potionEffects.remove(potionEffect.getId());
        }
        this.sendPotionEffects();
    }

    private void sendPotionEffects() {
        this.setData(MetaIndex.LIVING_POTIONS, this.getPotions());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    @MethodOnlyUsedBy(value={DisguiseType.PLAYER})
    public void setArrowsSticking(int arrowsNo) {
        this.setData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, arrowsNo)));
        this.sendData(MetaIndex.LIVING_ARROWS);
    }

    @Override
    protected byte addEntityAnimations(MetaIndex index, byte originalValue, byte entityValue) {
        if (index != MetaIndex.LIVING_META) {
            return super.addEntityAnimations(index, originalValue, entityValue);
        }
        for (int i = 0; i < 3; ++i) {
            if ((entityValue & 1 << i) == 0 || this.modifiedLivingAnimations[i]) continue;
            originalValue = (byte)(originalValue | 1 << i);
        }
        return originalValue;
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    @MethodOnlyUsedBy(value={}, group=MethodGroupType.HOLDABLE)
    public void setRightClicking(boolean rightClicking) {
        this.setMainHandRaised(rightClicking);
    }

    public boolean[] getModifiedLivingAnimations() {
        return this.modifiedLivingAnimations;
    }
}

