/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginDescriptionFile;

public class DisguiseCommandConfig {
    private File commandConfig = new File(LibsDisguises.getInstance().getDataFolder(), "configs/plugin-commands.yml");
    private HashMap<String, DisguiseCommand> commands = new HashMap();
    private boolean modifyCommands = false;

    private void loadConfig() {
        if (!this.commandConfig.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.commandConfig);
        for (String name : config.getKeys(false)) {
            DisguiseCommand command = this.commands.get(name);
            if (!config.isConfigurationSection(name)) continue;
            if (command == null) {
                DisguiseUtilities.getLogger().warning("Config defines '" + name + "' as a command but that command doesn't exist?");
                continue;
            }
            if (!config.isConfigurationSection(name)) {
                DisguiseUtilities.getLogger().warning("Improper config for " + name);
                continue;
            }
            ConfigurationSection section = config.getConfigurationSection(name);
            if (!name.equals("libsdisguises")) {
                command.setEnabled(section.getBoolean("enabled", true));
                command.setName(section.getString("name", name));
                command.setPermission(section.getString("permission", command.getPermission()));
            }
            command.setDescription(section.getString("description", command.getDescription()));
            if (!section.contains("aliases")) continue;
            command.setAliases(new ArrayList<String>(section.getStringList("aliases")));
        }
        this.modifyCommands = config.getBoolean("ModifyCommands", false);
    }

    private void saveConfig() {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<String, DisguiseCommand> entry : this.commands.entrySet()) {
            ConfigurationSection section = config.createSection(entry.getKey());
            DisguiseCommand command = entry.getValue();
            if (!command.getName().equals("libsdisguises")) {
                section.set("name", (Object)command.getName());
                section.set("permission", (Object)command.getPermission());
                section.set("enabled", (Object)command.isEnabled());
            }
            section.set("description", (Object)command.getDescription());
            section.set("aliases", command.getAliases());
        }
        String configString = config.saveToString();
        configString = configString.replaceAll("\n([a-zA-Z])", "\n\n$1");
        String s = "# The following can be changed to modify how the disguise commands are registered\n# This will only work on server startup\nModifyCommands: " + this.modifyCommands + "\n\n" + configString;
        this.commandConfig.delete();
        try {
            this.commandConfig.getParentFile().mkdirs();
            this.commandConfig.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (PrintWriter writer = new PrintWriter(this.commandConfig, "UTF-8");){
            writer.write(s);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        this.loadPlugin();
        this.loadConfig();
        this.saveConfig();
        if (!this.modifyCommands) {
            return;
        }
        this.registerCommands();
    }

    private void registerCommands() {
        PluginDescriptionFile desc = LibsDisguises.getInstance().getDescription();
        HashMap newMap = new HashMap();
        for (DisguiseCommand command : this.commands.values()) {
            if (!command.isEnabled()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            newMap.put(command.getName(), map);
            if (!command.getAliases().isEmpty()) {
                map.put("aliases", command.getAliases());
            }
            if (!Strings.isNullOrEmpty((String)command.getPermission())) {
                map.put("permission", command.getPermission());
            }
            if (Strings.isNullOrEmpty((String)command.getDescription())) continue;
            map.put("description", command.getDescription());
        }
        try {
            Field f = PluginDescriptionFile.class.getDeclaredField("commands");
            f.setAccessible(true);
            f.set(desc, newMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCommand(String name) {
        if (!this.modifyCommands) {
            return name;
        }
        DisguiseCommand command = this.commands.get(name);
        if (command == null || !command.isEnabled()) {
            return null;
        }
        return command.getName();
    }

    private void loadPlugin() {
        PluginDescriptionFile desc = LibsDisguises.getInstance().getDescription();
        for (Map.Entry entry : desc.getCommands().entrySet()) {
            DisguiseCommand command = new DisguiseCommand();
            command.setName((String)entry.getKey());
            Map map = (Map)entry.getValue();
            command.setPermission((String)map.get("permission"));
            if (map.containsKey("aliases")) {
                command.setAliases(new ArrayList<String>((Collection)map.get("aliases")));
            }
            command.setDescription(map.getOrDefault("description", "No description set"));
            command.setEnabled(true);
            this.commands.put((String)entry.getKey(), command);
        }
    }

    public class DisguiseCommand {
        private String name;
        private String description;
        private String permission;
        private List<String> aliases = new ArrayList<String>();
        private boolean enabled;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPermission() {
            return this.permission;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setPermission(String permission) {
            this.permission = permission;
        }

        public void setAliases(List<String> aliases) {
            this.aliases = aliases;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

