/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.enchants;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.enchants.MythicEnchantment;
import io.lumine.artifacts.items.SkillHolder;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.skills.SkillTrigger;
import io.lumine.xikage.mythicmobs.skills.TriggeredSkill;
import java.util.Queue;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.inventory.ItemStack;

public class AppliedEnchant
implements SkillHolder {
    private MythicEnchantment enchant;
    private int level;
    private String equippedSlot;
    private ItemStack item;

    public AppliedEnchant(MythicEnchantment enchant, int level, String equippedSlot) {
        this.enchant = enchant;
        this.level = level;
        this.equippedSlot = equippedSlot;
    }

    @Override
    public boolean runSkills(SkillCaster caster, SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger, Consumer<SkillMetadata> transformer) {
        if (!this.enchant.hasMechanics(cause)) {
            return false;
        }
        TriggeredSkill ts = new TriggeredSkill(cause, caster, origin, trigger, this.enchant.getMechanics(cause), true, meta -> {
            meta.getVariables().putString("enchant-name", this.enchant.getName());
            meta.getVariables().putInt("enchant-level", this.level);
            meta.getVariables().putString("equip-slot", this.equippedSlot);
            if (transformer != null) {
                transformer.accept((SkillMetadata)meta);
            }
        }, new Pair[0]);
        return ts.getCancelled();
    }

    @Override
    public boolean hasTimerSkills() {
        return this.enchant.hasTimerSkills();
    }

    @Override
    public void runTimerSkills(SkillCaster caster, long timer) {
        if (!caster.getEntity().asPlayer().isOnline()) {
            return;
        }
        SkillMetadata data = new SkillMetadata(SkillTrigger.TIMER, caster, null);
        data.getVariables().putString("enchant-name", this.enchant.getName());
        data.getVariables().putInt("enchant-level", this.level);
        data.getVariables().putString("equip-slot", this.equippedSlot);
        this.enchant.getTimerSkills().stream().forEach(skill -> {
            if ((double)timer % ((double)skill.getTimerInterval() / (double)Artifacts.inst().getConfiguration().getClockInterval()) == 0.0 && skill.usable(data)) {
                skill.execute(data);
            }
        });
    }

    @Override
    public Queue<SkillMechanic> getSkills(SkillTrigger cause) {
        return this.enchant.getMechanics(cause);
    }
}

