/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.profiles;

import io.lumine.artifacts.Artifacts;
import io.lumine.artifacts.profiles.Profile;
import io.lumine.xikage.mythicmobs.adapters.AbstractPlayer;
import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.TerminableRegistry;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileMaterial;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;

public class ProfileManager
implements Listener,
Terminable {
    private final Artifacts core;
    private final TerminableRegistry components = TerminableRegistry.create();
    public ConcurrentHashMap<UUID, Profile> cachedPlayers = new ConcurrentHashMap();
    private static List<Material> armorMaterials = Arrays.asList(Material.LEATHER_HELMET, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS, Material.LEATHER_HELMET, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, VolatileMaterial.GOLDEN_HELMET, VolatileMaterial.GOLDEN_CHESTPLATE, VolatileMaterial.GOLDEN_LEGGINGS, VolatileMaterial.GOLDEN_BOOTS, Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS);

    public ProfileManager(Artifacts core) {
        this.core = core;
        this.components.accept((Object)Events.subscribe(PlayerQuitEvent.class).handler(event -> this.cachedPlayers.remove(event.getPlayer().getUniqueId())));
        this.components.accept((Object)Events.subscribe(PlayerRespawnEvent.class).handler(event -> this.updatePlayerArmorDelayed(event.getPlayer())));
        this.components.accept((Object)Events.subscribe(InventoryInteractEvent.class).handler(event -> this.updatePlayerArmorDelayed((Player)event.getWhoClicked())));
        this.components.accept((Object)Events.subscribe(InventoryCloseEvent.class).handler(event -> this.updatePlayerArmor((Player)event.getPlayer())));
        this.components.accept((Object)Events.subscribe(PlayerItemBreakEvent.class).handler(event -> this.updatePlayerArmorDelayed(event.getPlayer())));
        this.components.accept((Object)Events.subscribe(PlayerSwapHandItemsEvent.class).handler(event -> this.updatePlayerArmorDelayed(event.getPlayer())));
        this.components.accept((Object)Events.subscribe(PlayerItemHeldEvent.class).handler(event -> this.updatePlayerWeaponDelayed(event.getPlayer())));
        this.components.accept((Object)Events.subscribe(PlayerDropItemEvent.class).handler(event -> this.clearPlayerWeaponDelayed(event.getPlayer())));
        this.components.accept((Object)Events.subscribe(InventoryClickEvent.class).handler(event -> {
            if (event.getSlotType() == InventoryType.SlotType.ARMOR || event.getSlotType() == InventoryType.SlotType.QUICKBAR) {
                this.updatePlayerArmorDelayed((Player)event.getWhoClicked());
            }
        }));
        this.components.accept((Object)Events.subscribe(EntityPickupItemEvent.class).handler(event -> {
            Player player;
            if (event.getEntity() instanceof Player && ((player = (Player)event.getEntity()).getInventory().getItemInHand() == null || player.getInventory().getItemInHand().getType() == Material.AIR)) {
                this.updatePlayerWeaponDelayed((Player)event.getEntity());
            }
        }));
        this.components.accept((Object)Events.subscribe(PlayerInteractEvent.class).handler(event -> {
            if (armorMaterials.contains(event.getPlayer().getItemInHand().getType())) {
                this.updatePlayerArmorDelayed(event.getPlayer());
            }
            if (event.getAction() == Action.PHYSICAL) {
                this.updatePlayerWeapon(event.getPlayer());
                return;
            }
        }));
    }

    public void close() {
        this.components.terminate();
    }

    private void updatePlayerArmor(Player player) {
        Artifacts.debug("Updating Armor");
        this.getPlayerProfile(player).parseArmor();
    }

    private void updatePlayerArmorDelayed(Player player) {
        Artifacts.debug("Updating Armor (Delayed)");
        Schedulers.sync().runLater(() -> this.updatePlayerArmor(player), 1L);
    }

    private void clearPlayerWeapon(Player player) {
        this.getPlayerProfile(player).clearWeapon();
    }

    private void clearPlayerWeaponDelayed(Player player) {
        Schedulers.sync().runLater(() -> this.clearPlayerWeapon(player), 1L);
    }

    private void updatePlayerWeapon(Player player) {
        Artifacts.debug("Updating Weapon");
        this.getPlayerProfile(player).parseWeapons();
    }

    private void updatePlayerWeaponDelayed(Player player) {
        Artifacts.debug("Updating Weapon (Delayed)");
        Schedulers.sync().runLater(() -> this.updatePlayerWeapon(player), 1L);
    }

    public Profile getPlayerProfile(Player p) {
        if (this.cachedPlayers.containsKey(p.getUniqueId())) {
            Artifacts.debug("Retrieving cached GearStats profile for " + p.getName().toString());
            Profile gs = this.cachedPlayers.get(p.getUniqueId());
            gs.setPlayer(p);
            return gs;
        }
        Artifacts.debug("Creating new GearStats profile for " + p.getName().toString());
        Profile gs = new Profile(p);
        gs.parseArmor();
        this.cachedPlayers.put(p.getUniqueId(), gs);
        return gs;
    }

    public Collection<Profile> getEquipmentProfiles() {
        return this.cachedPlayers.values();
    }

    public void runTimerSkills(long timer) {
        this.cachedPlayers.values().stream().forEach(profile -> {
            AbstractPlayer player = profile.getPlayer();
            if (profile.hasTimerSkills()) {
                profile.runTimerSkills(player, timer);
            }
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onDeath(PlayerDeathEvent event) {
        Profile profile = this.getPlayerProfile(event.getEntity());
        if (profile.getDeathMessage().isPresent()) {
            // empty if block
        }
    }
}

