/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.skills.mechanics;

import io.lumine.artifacts.Artifacts;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConsumeUsedItemMechanic
extends SkillMechanic
implements INoTargetSkill {
    private int amount;

    public ConsumeUsedItemMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.amount = mlc.getInteger(new String[]{"amount", "a"}, 1);
    }

    public boolean cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isPlayer()) {
            return false;
        }
        if (data.getVariables().has("equip-item")) {
            Player player = (Player)BukkitAdapter.adapt((AbstractEntity)data.getCaster().getEntity());
            ItemStack item = (ItemStack)data.getVariables().get("equip-item").get();
            if (item != null) {
                int newAmount = item.getAmount() - this.amount;
                if (newAmount <= 0) {
                    ConsumeUsedItemMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().destroyItem(item);
                    player.updateInventory();
                    Schedulers.sync().runLater(() -> Artifacts.inst().getProfileManager().getPlayerProfile(player).parseWeapons(), 1L);
                } else {
                    item.setAmount(newAmount);
                    player.updateInventory();
                }
            }
        }
        return true;
    }
}

