/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.artifacts.skills.mechanics;

import io.lumine.xikage.mythicmobs.drops.EquipSlot;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.skills.INoTargetSkill;
import io.lumine.xikage.mythicmobs.skills.SkillMechanic;
import io.lumine.xikage.mythicmobs.skills.SkillMetadata;
import io.lumine.xikage.mythicmobs.util.jnbt.IntTag;
import io.lumine.xikage.mythicmobs.util.jnbt.Tag;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class SetSlotModelMechanic
extends SkillMechanic
implements INoTargetSkill {
    private EquipSlot slot;
    private int model;

    public SetSlotModelMechanic(String line, MythicLineConfig mlc) {
        super(line, mlc);
        this.model = mlc.getInteger(new String[]{"model", "m"}, 0);
        String slotKey = mlc.getString(new String[]{"equipslot", "slot", "s"}, "HEAD", new String[0]);
        this.slot = EquipSlot.of((String)slotKey);
    }

    public boolean cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isLiving()) {
            return false;
        }
        LivingEntity e = (LivingEntity)data.getCaster().getEntity().getBukkitEntity();
        ItemStack slotitem = null;
        switch (this.slot) {
            case HEAD: {
                slotitem = e.getEquipment().getHelmet();
                break;
            }
            case CHEST: {
                slotitem = e.getEquipment().getChestplate();
                break;
            }
            case LEGS: {
                slotitem = e.getEquipment().getLeggings();
                break;
            }
            case FEET: {
                slotitem = e.getEquipment().getBoots();
                break;
            }
            case HAND: {
                slotitem = e.getEquipment().getItemInMainHand();
                break;
            }
            case OFFHAND: {
                slotitem = e.getEquipment().getItemInOffHand();
                break;
            }
            case NONE: {
                slotitem = null;
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.CONDITION, (String)"! Invalid slot used: {0}", (Object[])new Object[]{this.slot});
            }
        }
        if (slotitem == null) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.CONDITION, (String)"! Slot item was null, returning false", (Object[])new Object[0]);
            return false;
        }
        slotitem = SetSlotModelMechanic.getPlugin().getVolatileCodeHandler().getItemHandler().addNBTData(slotitem, "CustomModelData", (Tag)new IntTag(this.model));
        switch (this.slot) {
            case HEAD: {
                e.getEquipment().setHelmet(slotitem);
                break;
            }
            case CHEST: {
                e.getEquipment().setChestplate(slotitem);
                break;
            }
            case LEGS: {
                e.getEquipment().setLeggings(slotitem);
                break;
            }
            case FEET: {
                e.getEquipment().setBoots(slotitem);
                break;
            }
            case HAND: {
                e.getEquipment().setItemInMainHand(slotitem);
                break;
            }
            case OFFHAND: {
                e.getEquipment().setItemInOffHand(slotitem);
                break;
            }
        }
        return true;
    }
}

