/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.shadow.bukkit;

import io.lumine.shadow.Shadow;
import io.lumine.shadow.TargetResolver;
import io.lumine.shadow.bukkit.PackageVersion;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ObcClassTarget {
    public static final TargetResolver RESOLVER = new TargetResolver(){

        @Override
        public @NonNull Optional<Class<?>> lookupClass(@NonNull Class<? extends Shadow> shadowClass) throws ClassNotFoundException {
            ObcClassTarget annotation = shadowClass.getAnnotation(ObcClassTarget.class);
            if (annotation == null) {
                return Optional.empty();
            }
            return Optional.of(PackageVersion.runtimeVersion().obcClass(annotation.value()));
        }
    };

    public @NonNull String value();
}

