/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.adapters.bukkit.entities;

import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitEntityType;
import io.lumine.xikage.mythicmobs.adapters.bukkit.entities.properties.AgeableProperty;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import io.lumine.xikage.mythicmobs.mobs.entities.SpawnReason;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Parrot;

public class BukkitParrot
extends BukkitEntityType {
    protected static final int height = 1;
    private AgeableProperty ageableProperty;
    private Parrot.Variant variant;

    @Override
    public void instantiate(MythicConfig mc) {
        this.ageableProperty = new AgeableProperty(mc);
        String strcolor = mc.getString("Options.Color", null);
        if ((strcolor = mc.getString("Options.Variant", strcolor)) != null) {
            try {
                this.variant = Parrot.Variant.valueOf((String)strcolor);
            }
            catch (Exception ex) {
                MythicLogger.errorGenericConfig("Invalid parrot color/variant specified");
            }
        }
    }

    @Override
    public Entity spawn(Location location, SpawnReason reason) {
        Entity e = this.spawnEntity(location, EntityType.PARROT, reason);
        return e;
    }

    @Override
    public Entity applyOptions(Entity entity) {
        Parrot e = (Parrot)entity;
        this.ageableProperty.applyProperties(entity);
        if (this.variant != null) {
            e.setVariant(this.variant);
        }
        return e;
    }

    @Override
    public boolean compare(Entity e) {
        return e instanceof Parrot;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public Parrot.Variant getVariant() {
        return this.variant;
    }
}

