/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.debug;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.commands.CommandHelper;
import io.lumine.xikage.mythicmobs.commands.debug.TimingsCommand;
import io.lumine.xikage.mythicmobs.io.ConfigManager;
import io.lumine.xikage.mythicmobs.utils.chat.ColorString;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class DebugCommand
extends Command<MythicMobs> {
    public DebugCommand(Command<MythicMobs> parent) {
        super(parent);
        this.addSubCommands(new TimingsCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            String[] messages = new String[]{ColorString.get("  &7Arguments: &6[] &f= Required&7, &3<> &f= Optional"), "", ColorString.get("&e/mm d &3[level] &7\u25ba &7&oSets debug reporting. Can be between 0 and 4 (0=off,4=too much info)."), ColorString.get("&e/mm d &fmode &6[true/false] &7\u25ba &7&oSets debug mode on or off. See plugin manual for details)."), ColorString.get("&e/mm d &ftimings &7\u25ba &7&oShow basic timing information (timings must be on first)."), ColorString.get("&e/mm d &ftimings &3[on/off] &7\u25ba &7&oTurns timings on/off."), ColorString.get("&e/mm d &ftimings skills &7\u25ba &7&oShows skill-specific timings in the console."), ColorString.get("&e/mm d &ftimings spawners &7\u25ba &7&oShows spawner-specific timings in the console.")};
            CommandHelper.sendCommandMessage(sender, messages);
            return true;
        }
        try {
            ConfigManager.debugLevel = Integer.parseInt(args[0]);
            sender.sendMessage(ChatColor.GOLD + "[MythicMobs]" + ChatColor.GREEN + " Debug level has been set to " + args[0]);
        }
        catch (Exception e) {
            CommandHelper.sendError(sender, "Debug Level must be an integer (1-5).");
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.debug";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "debug";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"d"};
    }
}

