/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.commands.mobs;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.utils.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.StringUtil;

public class KillTypeCommand
extends Command<MythicMobs> {
    public KillTypeCommand(Command<MythicMobs> parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        String s2 = ChatColor.GREEN + "Mobs Killed: ";
        String type = args[0];
        for (LivingEntity l : MythicMobs.inst().getMobManager().getAllMythicEntities()) {
            ActiveMob am = MythicMobs.inst().getMobManager().getMythicMobInstance((Entity)l);
            if (am == null || !am.getType().getInternalName().contains(type)) continue;
            am.setDespawned();
            MythicMobs.inst().getMobManager().unregisterActiveMob(am);
            l.remove();
        }
        for (MythicMob mm3 : MythicMobs.inst().getMobManager().getMobTypes()) {
            if (!mm3.getInternalName().contains(type)) continue;
            String[] parts = mm3.getInternalName().split(type);
            if (parts.length == 2) {
                s2 = s2 + ChatColor.RED + parts[0] + ChatColor.DARK_RED + type + ChatColor.RED + parts[1] + ChatColor.GRAY + ", ";
            }
            if (parts.length == 1) {
                s2 = s2 + ChatColor.RED + parts[0] + ChatColor.DARK_RED + type + ChatColor.GRAY + ", ";
            }
            if (parts.length != 0) continue;
            s2 = s2 + ChatColor.DARK_RED + type + ChatColor.GRAY + ", ";
        }
        sender.sendMessage(s2);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], ((MythicMobs)this.getPlugin()).getMobManager().getMobNames(), new ArrayList());
        }
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "mythicmobs.command.mobs.kill";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "kill";
    }

    @Override
    public String[] getAliases() {
        return new String[]{"k"};
    }
}

