/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.compatibility;

import com.kirelcodes.miniaturepets.MiniaturePets;
import com.kirelcodes.miniaturepets.mob.Mob;
import com.kirelcodes.miniaturepets.mob.MobContainer;
import com.kirelcodes.miniaturepets.utils.APIUtils;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.io.MythicConfig;
import io.lumine.xikage.mythicmobs.logging.MythicLogger;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class MPetCompat {

    private class MythicMPet
    extends Mob {
        public MythicMPet(Location loc, MobContainer type) {
            super(loc, type);
        }
    }

    public class MiniaturePetType {
        private MobContainer mType;
        private String display;
        private boolean showName;
        private boolean valid = false;

        public MiniaturePetType(MythicConfig mc) {
            String type = mc.getString("MiniaturePet.Type", null);
            String anchor = mc.getString("MiniaturePet.Anchor", null);
            double speed = mc.getDouble("Options.MovementSpeed", 0.17);
            this.showName = mc.getBoolean("MiniaturePet.ShowName", false);
            this.showName = mc.getBoolean("MPet.ShowName", this.showName);
            this.display = mc.getColorString("DisplayName", "");
            this.display = mc.getColorString("Display", this.display);
            if (type == null) {
                type = mc.getString("MPet.Type", null);
            }
            if (anchor == null) {
                anchor = mc.getString("MPet.Anchor", null);
            }
            try {
                EntityType anchorType = EntityType.valueOf((String)anchor.toUpperCase());
                String path = MiniaturePets.getInstance().getDataFolder().getAbsolutePath() + "/pets/" + type + ".mpet";
                File file = new File(path);
                if (!file.exists()) {
                    MythicLogger.errorCompatibility("MiniaturePets", "Could not find file for pet type '" + type + "' at '" + path + "'");
                    return;
                }
                this.mType = APIUtils.loadContainer((File)file);
                this.mType.setAnchor(anchorType);
                this.mType.setSpeed(speed);
                this.valid = true;
            }
            catch (Exception ex) {
                MythicLogger.error("Invalid MiniaturePet Anchor type: " + anchor);
                ex.printStackTrace();
            }
        }

        public boolean isValid() {
            return this.valid;
        }

        public Entity spawn(AbstractLocation location) {
            MythicMPet mob = new MythicMPet(BukkitAdapter.adapt(location), this.mType);
            if (this.showName) {
                mob.setCustomName(this.display);
            }
            return mob.getNavigator();
        }
    }
}

