/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.skills.SkillCaster;
import io.lumine.xikage.mythicmobs.skills.placeholders.PlaceholderMeta;
import java.util.Optional;

public class DropMetadata
implements Cloneable,
PlaceholderMeta {
    private final Optional<SkillCaster> dropper;
    private final Optional<AbstractEntity> cause;
    private float amount = 0.0f;
    private int generations = 0;

    public DropMetadata(SkillCaster dropper, AbstractEntity killer) {
        this.dropper = Optional.ofNullable(dropper);
        this.cause = Optional.ofNullable(killer);
    }

    public int tick() {
        return this.generations++;
    }

    @Override
    public SkillCaster getCaster() {
        return this.dropper.isPresent() ? this.dropper.get() : null;
    }

    @Override
    public AbstractEntity getTrigger() {
        return this.cause.isPresent() ? this.cause.get() : null;
    }

    public Optional<SkillCaster> getDropper() {
        return this.dropper;
    }

    public Optional<AbstractEntity> getCause() {
        return this.cause;
    }

    public float getAmount() {
        return this.amount;
    }

    public int getGenerations() {
        return this.generations;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropMetadata)) {
            return false;
        }
        DropMetadata other = (DropMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<SkillCaster> this$dropper = this.getDropper();
        Optional<SkillCaster> other$dropper = other.getDropper();
        if (this$dropper == null ? other$dropper != null : !((Object)this$dropper).equals(other$dropper)) {
            return false;
        }
        Optional<AbstractEntity> this$cause = this.getCause();
        Optional<AbstractEntity> other$cause = other.getCause();
        if (this$cause == null ? other$cause != null : !((Object)this$cause).equals(other$cause)) {
            return false;
        }
        if (Float.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        return this.getGenerations() == other.getGenerations();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<SkillCaster> $dropper = this.getDropper();
        result = result * 59 + ($dropper == null ? 43 : ((Object)$dropper).hashCode());
        Optional<AbstractEntity> $cause = this.getCause();
        result = result * 59 + ($cause == null ? 43 : ((Object)$cause).hashCode());
        result = result * 59 + Float.floatToIntBits(this.getAmount());
        result = result * 59 + this.getGenerations();
        return result;
    }

    public String toString() {
        return "DropMetadata(dropper=" + this.getDropper() + ", cause=" + this.getCause() + ", amount=" + this.getAmount() + ", generations=" + this.getGenerations() + ")";
    }
}

