/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.drops.droppables;

import io.lumine.xikage.mythicmobs.adapters.AbstractItemStack;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitItemStack;
import io.lumine.xikage.mythicmobs.drops.Drop;
import io.lumine.xikage.mythicmobs.drops.DropMetadata;
import io.lumine.xikage.mythicmobs.drops.IItemDrop;
import io.lumine.xikage.mythicmobs.io.MythicLineConfig;
import io.lumine.xikage.mythicmobs.skills.SkillString;
import io.lumine.xikage.mythicmobs.utils.numbers.RandomDouble;
import java.util.ArrayList;

public class ItemDrop
extends Drop
implements IItemDrop {
    private final BukkitItemStack item;

    public ItemDrop(String line, MythicLineConfig config, String item) {
        super(line, config);
        this.item = new BukkitItemStack(item);
        String display = config.getString(new String[]{"name", "display", "n"}, null, new String[0]);
        int data = config.getInteger(new String[]{"data", "d"}, 0);
        int amount = config.getInteger(new String[]{"amount", "a"}, 1);
        String lore = config.getString(new String[]{"lore", "l"}, null, new String[0]);
        String color = config.getString(new String[]{"color", "c"}, null, new String[0]);
        if (display != null) {
            if (display.startsWith("\"")) {
                display = display.substring(1, display.length() - 1);
            }
            display = SkillString.parseMessageSpecialChars(display);
            this.item.name(display);
        }
        if (data > 0) {
            this.item.data((byte)data);
        }
        if (amount != 1) {
            this.item.amount(amount);
        }
        if (lore != null) {
            try {
                ArrayList<String> loreList = new ArrayList<String>();
                for (String s2 : lore.split(",")) {
                    String lores = s2.substring(1, s2.length() - 1);
                    lores = SkillString.parseMessageSpecialChars(lores);
                    loreList.add(lores);
                }
                this.item.lore(loreList);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (color != null) {
            this.item.color(color);
        }
    }

    public ItemDrop(String line, MythicLineConfig config, BukkitItemStack item) {
        super(line, config);
        this.item = item;
    }

    public ItemDrop(String line, MythicLineConfig config, BukkitItemStack item, RandomDouble amount) {
        super(line, config, amount);
        this.item = item;
    }

    @Override
    public AbstractItemStack getDrop(DropMetadata metadata) {
        int amount = (int)((double)this.item.getAmount() * this.getAmount());
        return this.item.clone().amount(amount);
    }

    public String toString() {
        return "ItemDrop{" + this.item.toString() + "}";
    }
}

