/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.skills.auras;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.skills.SkillManager;
import io.lumine.xikage.mythicmobs.skills.auras.AuraRegistry;
import io.lumine.xikage.mythicmobs.utils.tasks.Scheduler;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class AuraManager {
    private final MythicMobs core;
    private final SkillManager skillManager;
    private ConcurrentHashMap<UUID, AuraRegistry> auraRegistries = new ConcurrentHashMap();
    private Terminable garbageCollector;

    public AuraManager(MythicMobs core, SkillManager skillManager) {
        this.core = core;
        this.skillManager = skillManager;
        this.garbageCollector = Scheduler.runTaskRepeatingAsync(() -> this.auraRegistries.values().forEach(registry -> {}), 20L, 100L);
    }

    public void shutdown() {
        this.garbageCollector.terminate();
    }

    public AuraRegistry getAuraRegistry(AbstractEntity entity) {
        return this.getAuraRegistry(entity.getUniqueId());
    }

    public AuraRegistry getAuraRegistry(UUID uuid) {
        if (this.auraRegistries.containsKey(uuid)) {
            return this.auraRegistries.get(uuid);
        }
        AuraRegistry registry = new AuraRegistry(uuid);
        this.auraRegistries.put(uuid, registry);
        return registry;
    }

    public boolean getHasAura(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return false;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.hasAura(name);
    }

    public int getAuraStacks(AbstractEntity entity, String name) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return 0;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        return registry.getStacks(name);
    }

    public void removeAuraStacks(AbstractEntity entity, String buffName, int a) {
        if (!this.auraRegistries.containsKey(entity.getUniqueId())) {
            return;
        }
        AuraRegistry registry = this.auraRegistries.get(entity.getUniqueId());
        registry.removeStack(buffName, a);
    }
}

